{$X+,S-,R-,I-,Q-,N-,E-,G-,O-}
{$M 8192,0,20480}
program RHelp;
uses
   App, Views, Menus, Dialogs,
   Objects, Drivers, Memory, HistList, HelpFile, DOS;

const
   vstr=           '1.00';

   VideoSize=      4096;
   VideoX=         80;
   VideoY=         25;

   KeyboardNum=    $09;
   ActivateNum1=   $08;
   ActivateNum2=   $28;

   Code1=          $5A69;
   Code2=          $B10E;

   MaxPopUpTime=   18;

   DefaultWinSize  :TPoint=  (X:55; Y:20);

var
   HelpName        :PathStr;
   FileInfo        :SearchRec;
   MemOk           :Boolean;
   WinSize         :TPoint;
   WinZoomRect     :TRect;

   MouseState      :Pointer;
   MouseStateSize  :Word;

   LastHandlerMask :Word;
   LastHandler     :Pointer;

   CursorSize,
   CursorPos       :Word;

   MarkMem         :Pointer;

const
   cmAbout =       1002;

type
   PCenterButton=  ^TCenterButton;
   TCenterButton=
   object(TButton)

      constructor Init(var Bounds      :TRect;
                       ATitle          :TTitleStr;
                       ACommand        :Word;
                       AFlags          :Byte);
   end;

   PHelpStatusLine=     ^THelpStatusLine;
   THelpStatusLine=
   object(TStatusLine)
      function GetPalette              :PPalette; virtual;
   end;

   PHelpDialogWindow=   ^THelpDialogWindow;
   THelpDialogWindow=
   object(THelpWindow)

      StatusLine   :PHelpStatusLine;

      constructor Init(var ASize       :TPoint;
                       HFile           :PHelpFile;
                       Context         :Word);
      function GetPalette              :PPalette; virtual;
   end;

   PBackground=    ^TBackground;
   TBackground=
   object(TView)
      Buffer       :^TDrawBuffer;

      constructor Init;
      destructor  Done; virtual;

      procedure Draw; virtual;
   end;

   TRHelp=
   object(TProgram)
      constructor Init;
      destructor  Done; virtual;
      procedure   Run;  virtual;

      procedure   InitBackground;

      procedure GetEvent(var Event     :TEvent);  virtual;
      function  GetPalette             :PPalette; virtual;

      procedure About;
   end;

constructor TCenterButton.Init;
begin
   Inherited Init(Bounds, ATitle, ACommand, AFlags);
   Options:=Options or ofCenterX;
end;

function THelpStatusLine.GetPalette;
const
   P     :String[Length(CStatusLine)]=#9#10#11#12#13#14;
begin
   GetPalette:=@P;
end;

constructor THelpDialogWindow.Init;
var
   R     :TRect;
begin
   LongInt(R.A):=0; R.B:=ASize;

   TWindow.Init(R, 'Help', wnNoNumber);
   Options := Options or ofCentered;
   R.Grow(-2,-1); Inc(R.A.Y);
   Insert(New(PHelpViewer, Init(R,
     StandardScrollBar(sbHorizontal + sbHandleKeyboard),
     StandardScrollBar(sbVertical + sbHandleKeyboard), HFile, Context)));

   R.Assign(1, 1, Size.X-1, 2);
   StatusLine:=New(PHelpStatusLine, Init(R,
     NewStatusDef(0, $FFFF,
       NewStatusKey('~Esc~ Close', kbEsc, cmClose,
       NewStatusKey('~Alt-F1~ Last', kbAltF1, cmHelpPrev,
       NewStatusKey('~Shift-F1~ Contents', kbShiftF1, cmHelpIndex,
       NewStatusKey('~F1~ About', kbF1, cmAbout,
       NewStatusKey('~F5~ Zoom', kbF5, cmZoom,
       NewStatusKey('~Ctrl-F5~ Resize', kbCtrlF5, cmResize,
   nil)))))), nil)));

   if StatusLine<>nil then
   begin
      StatusLine^.GrowMode:=gfGrowHiX;
      Insert(StatusLine);
   end;
end;

function THelpDialogWindow.GetPalette;
const
   P     :String[Length(CHelpWindow)+Length(CStatusLine)] =
   CHelpWindow+CStatusLine;
begin
   GetPalette := @P;
end;

procedure TRHelp.GetEvent(var Event    :TEvent);
var
   W               :PWindow;
   HFile           :PHelpFile;
   HelpStrm        :PDosStream;

   R               :TRect;
   D               :PDialog;
const
   HelpInUse       :Boolean= False;
begin
   case Event.What of
      evCommand:
      case Event.Command of
         cmHelp:
         if not HelpInUse then
         begin
            HelpInUse := True;
            HelpStrm := New(PDosStream, Init(HelpName, stOpenRead));
            HFile := New(PHelpFile, Init(HelpStrm));
            if HelpStrm^.Status <> stOk then Dispose(HFile, Done) else
            begin
               W := New(PHelpDialogWindow, Init(WinSize, HFile, GetHelpCtx));
               if ValidView(W) <> nil then
               begin
                  if not WinZoomRect.Empty then W^.ZoomRect:=WinZoomRect;
                  ExecView(W);
                  WinSize:=W^.Size; WinZoomRect:=W^.ZoomRect;
                  Dispose(W, Done);
               end;
               ClearEvent(Event);
            end;
            HelpInUse := False;
         end;
         cmAbout:
         begin
            About;
            ClearEvent(Event);
         end;
      end;
      evMouseDown:
      if Event.Buttons <> 1 then Event.What := evNothing;
   end;
   Inherited GetEvent(Event);
end;

procedure TRHelp.About;
var
   D               :PDialog;
   Control         :PView;
   R               :TRect;
begin
   R.Assign(0, 0, 40, 13);
   D := New(PDialog, Init(R, 'About'));
   with D^ do
   begin
      Options := Options or ofCentered;

      R.Grow(-1, -1);
      Dec(R.B.Y, 3);
      Insert(New(PStaticText, Init(R,
       #13 +
       ^C'Resident Help Viewer'#13 +
       #13 +
       ^C'Version '+vstr+#13 +
       #13 +
       ^C'Copyright (c) 1994'#13 +
       #13 +
       ^C'by Solar Designer')));

      R.Assign(0, 10, 10, 12);
      Insert(New(PCenterButton, Init(R, 'O~K', cmOk, bfDefault)));
   end;
   ExecView(D);
   Dispose(D, Done);
end;

function TRHelp.GetPalette             :PPalette;
const
   CNewColor =       CAppColor + CHelpColor;
   CNewBlackWhite =  CAppBlackWhite + CHelpBlackWhite;
   CNewMonochrome =  CAppMonochrome + CHelpMonochrome;
   P  :array[apColor..apMonochrome] of string[Length(CNewColor)] =
   (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
   GetPalette := @P[AppPalette];
end;

procedure DoneEvents; assembler;
asm
   cmp  ButtonCount,0
   je   @@1
   cmp  MouseEvents,0
   je   @@1
   mov  MouseEvents,0
   mov  ax,14h
   mov  cx,LastHandlerMask
   les  dx,LastHandler
   int  33h
@@1:
end;

constructor TRHelp.Init;
var
   R               :TRect;
begin
   Mark(MarkMem);

   Application := @Self;

   InitMemory;
   ScreenWidth:=VideoX; ScreenHeight:=VideoY;

   if ScreenMode=smMono then ScreenBuffer:=Ptr($B000,0) else
      ScreenBuffer:=Ptr($B800,0);

   InitScreen;

   asm
      mov  ah,3
      mov  bh,0
      int  10h
      mov  CursorSize,cx
      mov  CursorPos,dx
   end;

   if MouseButtons<>0 then
   begin
      asm
         mov  ax,15h
         int  33h
         mov  MouseStateSize,BX
      end;

      MouseState:=MemAlloc(MouseStateSize);

      if MouseState<>nil then
      asm
         mov  ax,16h
         les  dx,MouseState
         int  33h
      end;
   end;

   InitEvents;
   asm
      mov  LastHandlerMask,cx
      mov  word ptr LastHandler,dx
      mov  word ptr LastHandler+2,es
   end;

   InitHistory;

   Application := @Self;
   R.Assign(0, 0, ScreenWidth, ScreenHeight);
   TGroup.Init(R);
   State := sfVisible + sfSelected + sfFocused + sfModal + sfExposed;
   Options := 0;
   Buffer := ScreenBuffer;

   MemOk:=True;
   InitBackground;
end;

destructor TRHelp.Done;
begin
   TGroup.Done;
   DoneHistory;
   DoneEvents;

   if (MouseButtons<>0) and (MouseState<>nil) then
   begin
      asm
         mov  ax,17h
         les  dx,MouseState
         int  33h
      end;
      FreeMem(MouseState, MouseStateSize);
   end;

   asm
      mov  ah,1
      mov  bh,0
      mov  cx,CursorSize
      int  10h
      mov  ah,2
      mov  dx,CursorPos
      int  10h
   end;

   DoneMemory;

   Release(MarkMem);
end;

procedure TRHelp.InitBackground;
begin
   Insert(New(PBackground, Init));
end;

procedure TRHelp.Run;
var
   Event           :TEvent;
begin
   Event.What:=evCommand; Event.Command:=cmHelp;
   PutEvent(Event); GetEvent(Event);
end;

constructor TBackground.Init;
var
   R     :TRect;
begin
   R.Assign(0, 0, ScreenWidth, ScreenHeight);
   Inherited Init(R);

   Buffer:=MemAllocSeg(VideoSize);
   if Buffer=nil then
   begin
      MemOk:=False; Fail;
   end;

   HideMouse;
   Move(ScreenBuffer^, Buffer^, VideoSize);
   ShowMouse;
end;

destructor TBackground.Done;
begin
   FreeMem(Buffer, VideoSize);
   Inherited Done;
end;

procedure TBackground.Draw;
begin
   WriteBuf(0, 0, Size.X, Size.Y, Buffer^);
end;

procedure ChangeInitEvents;
const
   LastCode =      $000C;
   NewCode =       $0014;
type
   TInitEvents =   Array [0..127] of Word;
var
   InitEventsA1,
   InitEventsA2    :^TInitEvents;
   i               :Integer;
begin
   InitEventsA1:=@InitEvents; InitEventsA2:=InitEventsA1;
   Inc(Word(InitEventsA2));
   For i:=0 to High(TInitEvents) do
   if (InitEventsA1^[i]=LastCode) or (InitEventsA2^[i]=LastCode) then
   begin
      if InitEventsA1^[i]=LastCode then InitEventsA1^[i]:=NewCode else
         InitEventsA2^[i]:=NewCode;
      Exit;
   end;
end;

procedure PopUpHelp;
var
   RHelpApp        :TRHelp;
begin
   asm
      mov  ah,0Fh
      int  10h
      xor  ah,ah
      mov  ScreenMode,ax
   end;

   if (ScreenMode<>smCO80) and (ScreenMode<>smBW80) and
      (ScreenMode<>smMono) then Exit;
   RHelpApp.Init;
   if MemOk then RHelpApp.Run;
   RHelpApp.Done;
end;

var
   LastVectK, LastVectA1, LastVectA2   :Pointer;
   DoPopUp, Working, CheckLoad         :Boolean;
   PopUpTime                           :Byte;
   DosActive                           :^Boolean;

procedure CheckActivate;
begin
   if DoPopUp and (not DosActive^) then
   begin
      DoPopUp:=False;
      if not Working then
      begin
         Working:=True; PopUpHelp; Working:=False;
      end;
   end;
end;

procedure KeyboardInt; interrupt;
label
   HotKey, Exit;
begin
   asm
      in   al,60h
      cmp  al,4Ch
      je   HotKey

      pushf
      call dword ptr LastVectK
      jmp  Exit
HotKey:
      in   al,61h
      mov  ah,al
      or   al,80h
      out  61h,al
      xchg ah,al
      out  61h,al
      mov  al,20h
      out  20h,al

      mov  DoPopUp,1
      mov  PopUpTime,MaxPopUpTime
      call CheckActivate
Exit:
   end;
end;

procedure ActivateInt1; interrupt;
begin
   asm
      pushf
      call dword ptr LastVectA1
   end;
   if PopUpTime>0 then Dec(PopUpTime) else DoPopUp:=False;
   CheckActivate;
end;

procedure ActivateInt2; interrupt;
label
   CallLast, Exit;
begin
   asm
      cmp  di,Code1
      jne  CallLast
      cmp  si,Code2
      jne  CallLast
      cmp  bx,offset CheckLoad
      jne  CallLast
      mov  byte ptr es:[bx],1
      jmp  Exit
CallLast:
      pushf
      call dword ptr LastVectA2
Exit:
   end;
   CheckActivate;
end;

begin
   writeln;
   writeln('Resident Turbo Vision Compatible Help Viewer  Version '+vstr);
   writeln('Copyright (c) 1994 by Solar Designer');
   writeln;

   if ParamCount<1 then
   begin
      writeln('Usage: RHELP.EXE [filename[.hlp]]'); writeln;
   end;

   if ParamCount>=1 then HelpName:=FExpand(ParamStr(1)) else HelpName:='*.HLP';
   if Pos('.', HelpName)=0 then HelpName:=HelpName+'.HLP';
   FindFirst(HelpName, AnyFile, FileInfo);
   if DOSError<>0 then
   begin
      writeln('File not found'); Halt;
   end;
   if ParamCount<1 then HelpName:=FExpand(FileInfo.Name);

   CheckLoad:=False;
   asm
      mov  di,Code1
      mov  si,Code2
      push ds
      pop  es
      mov  bx,offset CheckLoad
      int  ActivateNum2
   end;

   if CheckLoad then writeln('Already installed');

   writeln('To activate the help press ''5'' on the numeric keypad');

   if CheckLoad then Halt;

   ChangeInitEvents;
   LowMemSize:=1024 shr 4;
   RegisterHelpFile;

   WinSize:=DefaultWinSize;
   FillChar(WinZoomRect, SizeOf(WinZoomRect), 0);

   GetIntVec(KeyboardNum, LastVectK);
   GetIntVec(ActivateNum1, LastVectA1);
   GetIntVec(ActivateNum2, LastVectA2);

   asm
      mov  ah,34h
      int  21h
      mov  word ptr DosActive,bx
      mov  word ptr DosActive+2,es
   end;

   DoPopUp:=False; Working:=False;

   SetIntVec(KeyboardNum, Addr(KeyboardInt));
   SetIntVec(ActivateNum1, Addr(ActivateInt1));
   SetIntVec(ActivateNum2, Addr(ActivateInt2));

   SwapVectors;
   Keep(0);
end.


