{
  POLYX rasterizer

  FOR TMT only, version 3.0

}

unit Polyx2d;
interface
CONST

//--------------------------------------------------------
// BIOF FUNCTION

        BFRESET_PRIM      =1;
        BFRESETPRIM       =1;
        BFCLPAGE          =2;
        BFRENDER          =100;
        BFQUERYRENDER     =101;
        BFRENDERNOW       =102;
//--------------------------------------------------------
// UNIT TYPE
        UTFLAT          = 0;
        UTGUROUD        = 1;
        UTFLATTEX       = 2;
        UTGUROUDTEX     = 3;
        UTTEXONLY       = 4;
//--------------------------------------------------------
// ALPHAMODE
        AMSOLID         = 0;
        AMADD           = 1;
        AMMUL           = 2;
        AMTRUE          = 4;

// ALPHAMODE 3.0 Version ????
        BLENDNONE       = 0;
        BLENDADD        = 1;
        BLENDMUL        = 2;
        BLENDTRUE       = 4;

//--------------------------------------------------------
// TEXTURE COMBINED MODE
        TCNONE            =0;
        TCMULRGB          =1;
        TCADDRGB          =2;

        TRUE50          = 1;
        TRUE25          = 2;
        TRUE75          = 3;
//--------------------------------------------------------
// TEXTURE MODE
        TMEMPTY         = 0;
        TM15BIT         = 1;
        TM8BIT          = 2;

//--------------------------------------------------------
// INTERNAL SETTING
        V_CLEARPAGE     = 1;
        DETAIL          = 8;
        HalfConst       = (15 + 31 shl 5+15 shl 11)+ (15 + 31 shl 5+15 shl 11) shl 16;
        POLYBUFFER      = 8000;
        TEXTBUFFER      = 31;
        TXMAX           = 255;
        TYMAX           = 199;
        PAGESIZE        = (TXMAX+1)*(TYMAX+1) SHR 1;
type
        TVBUFFER        =ARRAY[0..TYMAX,0..TXMAX] of word;
        TEDGE           =ARRAY[0..TYMAX] OF RECORD X,R,G,B,U,V:LONGINT;END;
        TALPHACACHE     =ARRAY[0..32*32-1] OF Word;
        TTALPHACACHE    =ARRAY[0..2] OF Talphacache;
        VGAREG          =RECORD
                         CLIP       :RECORD XMIN,XMAX,YMIN,YMAX:LONGINT;END;
                         FLAGS      :DWORD;
                         BCOLOR     :WORD;
                         BITPERLINE :WORD;
                         MAXLINE    :WORD;
        END;
        TUNITS          =ARRAY[0..POLYBUFFER-1] OF RECORD Z:DWORD;PT:WORD;END;
        TUNITINFO       =RECORD
                          UNITTYPE,ALPHATYPE,NUMVERTEX:WORD;
                          FLCOL,TXNO,ALPNO,TEXCMB:WORD;
                         END;

//--------------------------------------------------------
// TEXTURE FORMAT HEADER
  TEXHEAD    =Object
                UM,VM           :INTEGER; // UM = 1,2,3,4,5,6,7,8,9 ( 8,16,...
                RAMPT           :Pointer;   // TEXTURE POINTER
                CTABLE          :Pointer;   // COLOR PALLETE TABLE POINTER
                COLORKEY        :WORD;    // COLOR KEY ( COLOR NOT SHOW )
                TEXTUREMODE     :WORD;

                Procedure Destroy;
                procedure Load(s:string);
  END;
  TEXFORM15  =ARRAY[0..1024] OF WORD;
  TEXFORM8   =ARRAY[0..1024] OF BYTE;
  TCOLTBL    =ARRAY[0..255] OF WORD;

  TTHEAD          =ARRAY[0..TEXTBUFFER] OF TEXHEAD;

//--------------------------------------------------------
        POINT_G         =RECORD X,Y,R,G,B,U,V:Longint   ;END; // G SHADE
        MPOINT_G        =Array[0..4] of POINT_G;
        TEMPGUROUD      =RECORD
                                INFO:TUNITINFO;
                                DATAS:MPOINT_G;
                         END;
CONST
//--------------------------------------------------------
// MAIN MEMORY USAGE
        CMDBUFFERSIZE = POLYBUFFER * SIZEOF(TEMPGUROUD);
        Alg             = dword ( not 3);
        FRAMERAM        =0;
        PRIMRAM         =(FRAMERAM+PAGESIZE*4+10) and Alg;
        ALPHA1RAM       =(PRIMRAM+CMDBUFFERSIZE+10) and Alg;
        ALPHA2RAM       =(ALPHA1RAM+SIZEOF(TALPHACACHE)+10) and Alg;
        ALPHA3RAM       =(ALPHA2RAM+SIZEOF(TALPHACACHE)+10) and Alg;
        THANDLERAM      =(ALPHA3RAM+SIZEOF(TTALPHACACHE)+10) and Alg;
        EDGERAM         =(THANDLERAM+SIZEOF(TTHEAD)+10) and Alg;

        SORTRAM         =(EDGERAM+SIZEOF(TEDGE)+10) and Alg;
        TOTALRAM        =(SORTRAM+SIZEOf(TUNITS)+10);


Var

//--------------------------------------------------------
// Dummy memory to easier access
        DTGUROUD        :^TEMPGUROUD;
        UNITINFO        :^TUNITINFO;
//--------------------------------------------------------
// Main important engine memory
    VRAM        :POINTER;
    VideoPage   :^TVbuffer;
    Edgebuffer  :^TEdge;
    AlphaAdd    :^TAlphaCache;
    AlphaMul    :^TAlphaCache;
    AlphaTrue   :^TTAlphaCache;
    MIXUSED     :^TALPHACACHE;
    CMIXUSED     :^TALPHACACHE;
    UNITS       :^TUNITS;
    TEXTURES    :^TTHEAD;
    TEXUSED15   :^TEXFORM15;
    TEXUSED8    :^TEXFORM8;
    COLTBL      :^TCOLTBL;
    DDD,CLKEY   :DWORD;
    PRIMPT      :Pointer;
    PRIMGO      :POINTER;
    VideoReg    :VGAREG;
    TEXU,TEXV   :WORD;
    PDRAWED     :WORD;
    PrimSize    :Integer;
    QuerySize   :Integer;
    UnitSize    :Integer;

    FlatColor   :Word:=0;
    SlTexture   :Word:=0;
    AlphaMode   :Word:=0;
    texcmbmode  :word:=0;
    TexMode     :Word:=0;
    ClearMode   :Word:=0;
    ldraw       :dword:=0;
    Xofs,Yofs   :Word:=0;

    ViewVtx     :Boolean:=false;
    flog        :text;

    procedure GINIT(Loc:Dword);
    procedure INC_UNIT;
    procedure Pset(x,y,c:longint);

    procedure QUERY_UNIT(DZ:Longint);
    procedure Abort_unit;
    procedure BIO(Func:Word);
    procedure Gqsort(var dat;ilo,ihi:dword);


implementation

// PlxDraw is the current rasterizer
{$i Plxdraw}

procedure Texhead.load(s:string);
var f:file;
    tm:word;
begin assign(f,s);
     reset(f,1);
     blockread(f,tm,2);um:=tm;
     blockread(f,tm,2);vm:=tm;
     blockread(f,Tm,2);texturemode:=tm;
     blockread(f,Tm,2);Colorkey:=tm;
     case texturemode of
          1:begin
                 getmem(rampt,(1 shl um)*(1 shl vm)*2);
                 blockread(f,rampt^,(1 shl um)*(1 shl vm)*2);
          end;
          2:begin
                 getmem(rampt,(1 shl um)*(1 shl vm));
                 getmem(ctable,512);
                 blockread(f,rampt^,(1 shl um)*(1 shl vm));
                 blockread(f,ctable^,512);
          end;
     end;
end;
procedure Texhead.destroy;
begin
        case texturemode of
             1:begin
                    freemem(rampt,(1 shl um)*(1 shl vm)*2);
                    texturemode:=0;
               end;
             2:begin
                    freemem(ctable,512);
                    freemem(rampt,(1 shl um)*(1 shl vm));
                    texturemode:=0;

               end;
        end;
end;
//--------------------------------------------------------------------
procedure ClearPage;assembler;
asm
   MOV edi,videopage
   mov ecx,PageSize
   mov ax,[VideoREG.BColor]
   rol eax,16
   mov ax,[VideoREG.BColor]
   rep stosd
end;

procedure Pset(x,y,c:longint);
begin
     if (x>=videoreg.clip.xmin) and (x<=videoreg.clip.xmax) and
        (y>=videoreg.clip.ymin) and (y<=videoreg.clip.ymax)
     then
     asm
      imul eax,y,640
      mov edi,x
      shl edi,1
      add edi,eax
      add edi,videopage
      mov eax,c
      stosw
     end;
end;
//--------------------------------------------------------------------
procedure GINIT;
var i,j,l,k,m,n:Longint;
    Tmp:^Talphacache;
begin
        Vram            := pointer(Loc);
        Unitsize        := SIzeOf(TempGuroud);
        ALPHAADD        := VRAM + ALPHA1RAM;
        ALPHAMUL        := VRAM + ALPHA2RAM;
        ALPHATRUE       := VRAM + ALPHA3RAM;
        VIDEOPAGE       := VRAM + FRAMERAM;
        Edgebuffer      := VRAM + EDGERAM;
        primpt          := VRAM + PRIMRAM;
        UNITS           := VRAM + SORTRAM;
        TEXTURES        := VRAM + THANDLERAM;

        VIDEOREG.CLIP.xmin := 0;
        VIDEOREG.CLIP.ymin := 0;
        VIDEOREG.CLIP.xmax := TXMAX;
        VIDEOREG.CLIP.ymax := TYMAX;
        VIDEOREG.FLAGS     := not 0;
        VIDEOREG.BCOLOR    := 0;
        VIDEOREG.BITPERLINE:= 640;
        VIDEOREG.MAXLINE   := 200;
        XOFS               := 0;
        YOFS               := 0;
        ViewVtx            := false;
        ClearMode          := 0;
        Okey       := false;

        for i:=0 to TYMAX do Edgebuffer^[i].x:=-1;
        for i:=0 to TextBuffer do textures^[i].Texturemode:=TMempty;

        InitRender;

        m:=0;
        for i:=0 to 31 do
        for j:=0 to 31 do begin
                k:=j*i div 16;
//                if i=29 then k:=K*3 div 2;
//                if i=30 then k:=K*2;
//                if i=31 then k:=K*4;
            if k>31 then k:=31;
                AlphaMul^[m]:=k;
                k:=i+j;
            if k>31 then k:=31;
                AlphaAdd^[m]:=k;

              for l:=1 to 3 do begin
                    k:=(i*(4-l)+j*l) div 4;
                    AlphaTrue^[l-1,m]:=k;
                end;
            m:=m+1;
      end;
end;
//--------------------------------------------------------------------
procedure INC_UNIT;
begin
  asm
     movzx eax,unitsize
     INC PRIMSIZE
     add primpt,eax
  end;
end;
//--------------------------------------------------------------------
procedure QUERY_UNIT(DZ:Longint);
begin
        with UNITS^[QUERYSIZE] do begin
                Z:=Dz;
                Pt:=PrimSize;
        end;
        INC(QUERYSIZE);
        INC_UNIT;
end;
//--------------------------------------------------------------------
procedure Abort_unit;
begin
  asm
     movzx eax,unitsize
     DEC PRIMSIZE
     SUB primpt,eax
  end;
end;
//--------------------------------------------------------------------

procedure BIO(Func:Word);
var i,R:word;
    PARAMW:^WORD;
begin
  case Func of
//--------------------------------------------------------------------
                bfQueryRENDER:
                If QuerySize>0 then
                BEGIN
                     If querysize>2 then Gqsort(Units^,0,QuerySize-1);
                     For i:=0 to QuerySize-1 do begin
                        PRIMGO   :=pointer(VRAM+PRIMRAM+Units^[i].pt*UnitSize);
                        UNITINFO :=POINTER(PRIMGO);
                        Dtguroud :=Primgo;
                        inc(primgo,SizeOf(TunitInfo));
                        With UnitInfo^ do begin
                             FlatColor:=FlCol;
                             SlTexture:=TxNo;
                             Alphamode:=Alphatype;
                             TEXCMBMODE:=TEXCMB;
                             case alphatype of
                                amadd           :Mixused:=alphaadd;
                                ammul           :begin Mixused:=alphamul;alphamode:=amadd;end;
                                amTRUE          :begin Mixused:=@alphatrue^[Alpno];alphamode:=amadd;end;
                             end;
                             case TEXCmB of
                                TCADDRGB        :CMixused:=alphaadd;
                                TCMULRGB        :begin CMixused:=alphamul;end;
                             end;
                             case Unittype of
                                utGuroud        :Polygon_g(numvertex);
                                utGuroudTEX     :Polygon_gt(numvertex);
                                utflat          :polygon_f(numvertex);
                                utflattex       :polygon_ft(numvertex);
                                uttexonly       :begin
                                                        alphamode:=amsolid;
                                                        polygon_ft(numvertex);
                                                end;
                             end;
                             INC(PDRAWED);
                        end;
                     end;
                     primpt:=VRAM+PRIMRAM;
                     PrimSIZE:=0;
                     QuerySIZE:=0;
    END;
//--------------------------------------------------------------------
                bfRENDER:
                If primsize>0 then
                BEGIN // EXIT ON UNKNOWN PRIMITIVE
                     PRIMGO:=VRAM+PRIMRAM;
                     For i:=0 to PrimSize-1 do begin

                        UNITINFO:=POINTER(PRIMGO);
                        inc(primgo,SizeOf(TunitInfo));
                        With UnitInfo^ do begin
                             FlatColor:=FlCol;
                             SlTexture:=TxNo;
                             Alphamode:=Alphatype;
                             TEXCMBMODE:=TEXCMB;
                             case alphatype of
                                amadd           :Mixused:=alphaadd;
                                ammul           :begin Mixused:=alphamul;alphamode:=amadd;end;
                                amTRUE          :begin Mixused:=@alphatrue^[Alpno];alphamode:=amadd;end;
                             end;
                             case TEXCmB of
                                TCADDRGB        :CMixused:=alphaadd;
                                TCMULRGB        :begin CMixused:=alphamul;end;
                             end;
                             case Unittype of
                                utGuroud        :Polygon_g(numvertex);
                                utGuroudTEX     :Polygon_gt(numvertex);
                                utflat          :polygon_f(numvertex);
                                utflattex       :polygon_ft(numvertex);
                                uttexonly       :begin
                                                        alphamode:=amsolid;
                                                        polygon_ft(numvertex);
                                                end;
                             end;
                             INC(PDRAWED);
                        end;
                        inc(primgo,UnitSize-SizeOf(TunitInfo));

                     end;
                     primpt:=VRAM+PRIMRAM;
                     PrimSIZE:=0;
    END;
//--------------------------------------------------------------------
                bfRENDERNow:begin
                        PrimGo:=Primpt;
                        UNITINFO:=POINTER(PRIMGO);
                        inc(primgo,SizeOf(TunitInfo));
                        With UnitInfo^ do begin
                             FlatColor:=FlCol;
                             SlTexture:=TxNo;
                             Alphamode:=Alphatype;
                             TEXCMBMODE:=TEXCMB;
                             case alphatype of
                                amadd           :Mixused:=alphaadd;
                                ammul           :begin Mixused:=alphamul;alphamode:=amadd;end;
                                amTRUE          :begin Mixused:=@alphatrue^[Alpno];alphamode:=amadd;end;
                             end;
                             case TEXCmB of
                                TCADDRGB        :CMixused:=alphaadd;
                                TCMULRGB        :begin CMixused:=alphamul;end;
                             end;
                             case Unittype of
                                utGuroud        :Polygon_g(numvertex);
                                utGuroudTEX     :Polygon_gt(numvertex);
                                utflat          :polygon_f(numvertex);
                                utflattex       :polygon_ft(numvertex);
                                uttexonly       :begin
                                                        alphamode:=amsolid;
                                                        polygon_ft(numvertex);
                                                end;
                             end;
                             INC(PDRAWED);
                        end;
    END;
//--------------------------------------------------------------------
                bfRESET_PRIM:BEGIN
                        primpt:=VRAM+PRIMRAM;
                        PrimSIZE:=0;
                        QuerySize:=0;
                END;
//--------------------------------------------------------------------
                bfCLPAGE:begin
                              ClearPage;
                         end;
  end;
end;

procedure Gqsort(var dat;ilo,ihi:dword);
var Lo,Hi:dWord;
begin
asm
     mov   eax,ilo
     mov   lo,eax
     mov   ebx,ihi
     mov   hi,ebx
     mov   edi,dat
     add   ebx,eax
     shr   ebx,1
     imul  ebx,6
     mov   edx,[edi+ebx]
     imul  ebx,lo,6
     add   ebx,edi
     imul  esi,hi,6
     add   esi,edi
@@1: cmp   [ebx],edx
     jle   @@2
     inc   lo
     add   ebx,6
     jmp   @@1
@@2: cmp   [esi],edx
     jge   @@3
     dec   hi
     sub   esi,6
     jmp   @@2
@@3: mov   eax,lo
     cmp   eax,hi
     jg    @@4
     mov   eax,[ebx]
     xchg  eax,[esi]
     mov   [ebx],eax
     mov   ax,[ebx+4]
     xchg  ax,[esi+4]
     mov   [ebx+4],ax

     add   ebx,6
     sub   esi,6
     inc   lo
     dec   hi
     mov   eax,lo
     cmp   eax,hi
     jle   @@1
@@4: mov   eax,hi
     cmp   eax,ilo
     jle   @@5
     push  dat
     push  ilo
     push  hi
     call  Gqsort
@@5: mov   eax,lo
     cmp   eax,ihi
     jge   @@6
     push  dat
     push  lo
     push  ihi
     call  Gqsort
@@6:
end;
end;

end.