{$define trlight}

{
FLAGS
+ T&L
     - T MODE  > SELECTION
         - XTSTATIC
         - XDINAMYC
         - XTNONE
         - XTRENORMAL
     - L MODE  > SELECTION
         - XLNONE
         - XLDIFFUSION   DIFFUSION ONLY
         * XLSPECULAR    &DIFFUSION
           - DEPEND ON LIGHT

+ LIGHT
     - L MODE  > BIT MASK ( CAN BE ADDED )
         - XLUSPECULAR   PERFORM SPECULAR EFFECT
         - XLUDISTANCE   PERFORM DISTANCE EFFECT

}

{ Transform & Lightning


  1. Accept compiled vertex and faces
     * Vertex - Coordinate
              - Normal vector
              - Color,texture coord

     * Face   - Group of vertex
              - Status

}

Const
       rrange=100;
// Light ADD flags
        XLGPERMANENT = 1;
        XLGTHISFRAME = 2;
        XLGAMBIENT   = 3;
// Light unit flags ( BIT MASK )
        XLUSPECULAR = 1;
        XLUDISTANCE = 2;
// T&L ( SELECT )
        XTSTATIC   = 0;
        XTDINAMYC  = 1;
        XTNONE     = 2;
//     ( SELECT )
        XLNONE     = 0 SHL 2;
        XLDIFFUSION= 1 SHL 2;
        XLSPECULAR = 2 SHL 2; // diffusion also
        XLENVSPECULAR = 4 SHL 2; // diffusion also
        XLRENORMAL = 8 SHL 2; // CALC NORMAL VECTOR

// Faces
        FCCULL = 1 shl 18;

{$ifdef graph2}
        VYSCALE = 400*480 DIV (TxMAX+1);
{$else}
        VYSCALE = 350*(TyMAX+1) div 200;
{$endif}
Type

        X_ocoord=record x,y,z :Single; end;
        X_onormal=record x,y,z:Single; end;

        X_rcoord=record x,y  :Longint; end;
        X_Gcolor=record r,g,b:Dword; end;
        X_Tcoord=record u,v  :Longint; end;

        X_overtex=record Crd:X_ocoord;
                         Nr :X_onormal;
                         GCLR:X_gcolor;
                         TCRD:X_tcoord;
                  end;
        X_rvertex=record Crd:X_rcoord;
                         GCLR:X_gcolor;
                         TCRD:X_tcoord;
                  end;
        X_Camera=record X,y,z:Single;
                        pa,pb,pc,sa,ca,sb,cb,sc,cc:Single;
                 end;
        X_TL=record x,y,z,sX,sy,sz:Single;
                        sa,ca,sb,cb,sc,cc:Single;
                        Flags:Dword;
                 end;
        X_Light=Record Clr  :X_Gcolor;
                       SClr :X_Gcolor;
                       X,y,z:Single;
                       LgFlags:Dword;

                end;
        X_LRN=RECORD NF:WORD;
                     DT:ARRAY[0..40] OF WORD;
              END;
        N_LRN=ARRAY[0..1000] OF X_LRN;
        XXXxF=array[0..35,0..3] of Word;
var

    LOCRN               :^N_LRN;
    XLight              :array[0..7] of X_light;
    Nlight              :Word;
    Xalight             :X_light;
    XCam                :X_camera;
    zrate,xctr,yctr     :longint;
    zmax                :Longint;
    TempVtx             :array[0..8000] of x_rvertex;
    TempZ               :array[0..8000] of Longint;
    Bfremove            :boolean;
    zadd                :longint;

    TRANS               :X_TL;
    TLFLAG              :Dword;
    TLDATAN             :POINTER;
    TLDATAV             :POINTER;
    TLDATAF             :POINTER;
    TLNUMV              :DWORD;
    TLNUMF              :DWORD;



        procedure Xlights(flag:word;var data);
        BEGIN
                Case flag of
                 XLGpermanent:if nlight<7 then
                              begin
                                Move(data,Xlight[nlight],Sizeof(x_light));
                                inc(nlight);
                              end;
                 XlgAmbient:Move(data,XAlight,Sizeof(x_light));
                 end;
        end;



        procedure Initx(loc:dword);
        begin
                TRANS.sa:=sin(0);
                TRANS.ca:=cos(0);
                TRANS.sb:=sin(0);
                TRANS.cb:=cos(0);
                TRANS.sc:=sin(0);
                TRANS.cc:=cos(0);
                TRANS.sx:=1;
                TRANS.sy:=1;
                TRANS.sz:=1;
                TRANS.x:=0;
                TRANS.y:=0;
                TRANS.z:=0;
                xcam.sa:=sin(0);
                xcam.ca:=cos(0);
                xcam.sb:=sin(0);
                xcam.cb:=cos(0);
                xcam.sc:=sin(0);
                xcam.cc:=cos(0);
                xcam.x:=0;
                xcam.y:=0;
                xcam.z:=-1000;
                zmax:=200000;
                Xctr:=(TXMAX+1) div 2;
                yctr:=(TyMAX+1) div 2;
                Ginit(Loc);
                xalight.clr.r:=20;
                xalight.clr.g:=20;
                xalight.clr.b:=20;
                Bfremove:=true;
                Nlight:=0;
        end;
type nx=array[0..1000] of x_overtex;

Var FaceShow  :Array[0..8000] of byte;
    VertLight :Array[0..8000] of byte;
    VertLightD:Array[0..8000] of record vix,viy,viz:single;end;
    FaceNorm  :Array[0..8000] of record nix,niy,niz:single;end;

{ This procedures perform Transform and Lightning }
procedure XTRANSFORM;
Var V3d                         :^nX;
    iii,lllx,llly,lllz,vv,z1,y2 :single;
    x1,llx,lly,llz,vl,Intl,nx   :single;
    ny,nz,xx,yy,zz,ix,iy,xl,yl  :single;
    iz,da,db,dc                 :single;
    six,siy,siz                 :single;
    Ir,Ig,Ib,i,zl,zk            :Longint;
    AT1                         :X_Gcolor;
    AT2                         :X_Tcoord;
    ar,ag,ab                    :Integer;
    TFLAG,LFLAG,NUM,LO1         :INTEGER;
    tix,tiy,tiz                 :single;
begin
  TFLAG:=TRANS.Flags and 3;
  LFLAG:=(TRANS.Flags) and (3 SHL 2);
  v3d:=TLDATAV;
  NUM:=TLNUMV;
  tix := TRANS.X;
  tiy := TRANS.Y;
  tiz := TRANS.Z;
  LO1:=0;
  repeat
      Dec(num);
      With V3d^[num] do begin
      CASE TFLAG OF
           XTSTATIC,XTNONE:
                     BEGIN
                          ix := crd.x*TRANS.sx+TRANS.X;
                          iy := crd.y*TRANS.sy+TRANS.Y;
                          iz := crd.z*TRANS.sz+TRANS.Z;
                     END;
           XTDINAMYC:
                     BEGIN
                          ix := crd.x*TRANS.sx;
                          iy := crd.y*TRANS.sy;
                          iz := crd.z*TRANS.sz;

                          x1 := ix*TRANS.ca + iz*TRANS.sa;
                          z1 := iz*TRANS.ca - ix*TRANS.sa;

                          y2 := iy*TRANS.cb + z1*TRANS.sb;
                          iz := z1*TRANS.cb - iy*TRANS.sb +TRANS.z;

                          ix := x1*TRANS.cc + y2*TRANS.sc +TRANS.x;
                          iy := y2*TRANS.cc - x1*TRANS.sc +TRANS.y;
                     END;
      END;
      VERTLIGHTD[NUM].vIX:=IX;
      VERTLIGHTD[NUM].vIY:=IY;
      VERTLIGHTD[NUM].vIZ:=IZ;
      CASE TFLAG OF
           XTSTATIC,XTDINAMYC:
                     BEGIN
                          six:=ix-xcam.x;
                          siy:=iy-xcam.y;
                          siz:=iz-xcam.z;

                          x1 := six*xcam.ca + siz*xcam.sa;
                          z1 := siz*xcam.ca - six*xcam.sa;
                          y2 := siy*xcam.cb + z1*xcam.sb;
                          vv := z1*xcam.cb - siy*xcam.sb;
                     END;
           XTNONE:
                     BEGIN
                          IF LO1=0 THEN BEGIN
                             six:=tix-xcam.x;
                             siy:=tiy-xcam.y;
                             siz:=tiz-xcam.z;

                             x1 := six*xcam.ca + siz*xcam.sa;
                             z1 := siz*xcam.ca - six*xcam.sa;
                             y2 := siy*xcam.cb + z1*xcam.sb;
                             TIZ := z1*xcam.cb - siy*xcam.sb;
                             TIX := x1*xcam.cc + y2*xcam.sc;
                             TIY := y2*xcam.cc - x1*xcam.sc;
                             LO1:=1;
                          END;
                          VV:=IZ-TRANS.Z+TIZ;
                          XL:=IX-TRANS.X+TIX;
                          YL:=IY-TRANS.Y+TIY;
                     END;
      END;

      At1:= GClr;
      At2:= TCrd;
      END;



      With TempVtx[num] do begin
// Check Z range
           zl  := round(vv);
           if (zl<50) or (zl>Zmax) then begin
              Tempz[num]:=-1;
              continue;
           end;
           vl:=vv;
// Check X range
           if zl<4 then vl:=4;
           if tflag<>xtnone then xl := x1*xcam.cc + y2*xcam.sc;
           crd.X   := round(xl*350/vl)+xctr;
           if (crd.x<0-Rrange) or (crd.x>Txmax+Rrange)then begin
                   tempz[num]:=-1;
                   continue;
           end;

// Check Y range
           if tflag<>xtnone then yl := y2*xcam.cc - x1*xcam.sc;
           crd.Y   := round(yl*350/vl)+yctr;
           if (crd.y<0-Rrange) or (crd.y>TYmax+Rrange)then begin
                   tempz[num]:=-1;
                   continue;
           end;

           Tempz[num]:=zl;

           gclr:=at1;
           tcrd:=at2;
      end; { With tempvtx ... }
until num<=0; { from top }

end;
procedure XLIGHTNING;
Var V3d                         :^nX;
    iii,lllx,llly,lllz,vv,z1,y2 :single;
    x1,llx,lly,llz,vl,Intl,nx   :single;
    ny,nz,xx,yy,zz,ix,iy,xl,yl  :single;
    iz,da,db,dc                 :single;
    six,siy,siz                 :single;
    Ir,Ig,Ib,i,zl,zk            :Longint;
    AT1                         :X_Gcolor;
    AT2                         :X_Tcoord;
    ar,ag,ab,jr,jg,jb,nnn,j     :longint;
    TFLAG,LFLAG,NUM,ma,env,RNM,SPC,DIF:INTEGER;
    nnx,nnz:single;
begin
  TFLAG:=TRANS.Flags and 3;
  env:=TRANS.Flags and XLenvspecular;
  RNM:=TRANS.Flags and XLRENORMAL;
  dif:=TRANS.Flags and XLdiffusion;
  spc:=TRANS.Flags and XLspecular;
  LFLAG:=(TRANS.Flags) and (15 SHL 2);
  v3d:=TLDATAV;
  NUM:=TLNUMV;
  locrn:=tldataN;
  ma:=0;
  repeat
      Dec(num);
      IF VERTLIGHT[NUM]=0 THEN CONTINUE;
      inc(ma);
{ perform Lightning }
      IF LFLAG<>XLNONE THEN begin
{$ifdef TrLight}
                With V3d^[num] do begin
                     jr := GClr.r;
                     jg := GClr.g;
                     jb := GClr.b;

                     nx := nr.x;
                     ny := nr.y;
                     nz := nr.z;
                END;

// calculate normal vectors
           If RNM>0 then
           With locrn^[num] do begin
                if nf>0 then begin
                    nx:=0;
                    ny:=0;
                    nz:=0;
                   for j:=0 to nf-1 do begin
                        nx:=nx+facenorm[dt[j]].nix;
                        ny:=ny+facenorm[dt[j]].niy;
                        nz:=nz+facenorm[dt[j]].niz;
                   end;
                   nx:=nx/nf;
                   ny:=ny/nf;
                   nz:=nz/nf;
                   end;
                   end;


                With TempVtx[num] do begin

                IF TFLAG=XTDINAMYC THEN BEGIN
                   x1 := nx*TRANS.ca + nz*TRANS.sa;
                   z1 := nz*TRANS.ca - nx*TRANS.sa;
                   y2 := ny*TRANS.cb + z1*TRANS.sb;
                   nz := z1*TRANS.cb - ny*TRANS.sb;
                   nx := x1*TRANS.cc + y2*TRANS.sc;
                   ny := y2*TRANS.cc - x1*TRANS.sc;
                END; { IF TLFLAG ... }
//            tcrd.u:=round((nz+1)/2*1023);
//            tcrd.v:=round((nx+1)/2*1023);


                ir := Xalight.clr.r;
                ig := Xalight.clr.g;
                ib := Xalight.clr.b;
                ar := 0;
                ag := 0;
                ab := 0;
                with vertlightd[num] do begin
                IX := vIX;
                IY := vIy;
                IZ := vIz;
                end;
                IF (SPC>0) or (env>0) THEN BEGIN
                   lllx:=(ix-xcam.x);
                   llly:=(iy-xcam.y);
                   lllz:=(iz-xcam.z);
                   vv := sqrt(sqr(lllx)+sqr(llly)+sqr(lllz));
                   if vv<0.0001 then vv:=0.0001;

                   lllx:=lllx/vv;
                   llly:=llly/vv;
                   lllz:=lllz/vv;
                end;
                if env>0 then begin
                   x1 := nx*xcam.ca + nz*xcam.sa;
                   z1 := nz*xcam.ca - nx*xcam.sa;
                   y2 := ny*xcam.cb + z1*xcam.sb;
//                   nnz := z1*xcam.cb - ny*xcam.sb;
                   nnx := x1*TRANS.cc + y2*TRANS.sc;
                   nnz := y2*TRANS.cc - x1*TRANS.sc;


                tcrd.u:=round(((-lllx+nnx)+2)/4*1023);
                tcrd.v:=round(((-lllz+nnz)+2)/4*1023);

                end;

                if (nlight>0) and ((spc>0) or (dif>0)) then
                For I:=0 to NLight-1 do with Xlight[i] do begin


                    llx:=(ix-x);
                    lly:=(iy-y);
                    llz:=(iz-z);

//                    if flags and XLUDistance=0 then
                    vl := sqrt(sqr(llx)+sqr(lly)+sqr(llz));
//                    else vl := (sqr(llx)+sqr(lly)+sqr(llz))/500;

                    if vl<0.0001 then vl:=0.0001;

                    intl := (llx*nx+lly*ny+llz*nz)/vl;
                    if Intl>0 then begin
                    IF DIF>0 THEN BEGIN
                          Ir:=Ir+round(Intl*Clr.R);
                          Ig:=Ig+round(Intl*Clr.g);
                          Ib:=Ib+round(Intl*Clr.b);
                    END;
                    END;
// Scpecular highlights

                    IF SPC>0 THEN begin
                       llx:=llx/vl+lllx;
                       lly:=lly/vl+llly;
                       llz:=llz/vl+lllz;

                       vv := sqrt(sqr(llx)+sqr(lly)+sqr(llz));
                       if vv<0.0001 then vv:=0.0001;
//                tcrd.u:=round((llx/vv+1)/2*1023);
//                tcrd.v:=round((-llz/vv+1)/2*1023);

                       llx:=(llx*nx+lly*ny+llz*nz)/vv;
                       if llx>0 then begin
                          llx:=sqr(sqr(sqr(sqr(sqr(llx)))));
                          with sclr do begin
                          ar:=ar+round(r*llx);
                          ag:=ag+round(g*llx);
                          ab:=ab+round(b*llx);
                          end;
                       end; // if llx>0
                    end; // if spc...
//                    end; // if intl>0...

                end; // For ...

{                ir:=255;
                ig:=255;
                ib:=255;}
                IF DIF>0 THEN BEGIN
                jr:=jr*ir shr 8;
                jg:=jg*ig shr 8;
                jb:=jb*ib shr 8;
                END;
                IF SPC>0 THEN BEGIN
                JR+:=AR;
                JG+:=AG;
                JB+:=AB;
                END;
                If jr>255 then jr:=255;
                If jg>255 then jg:=255;
                If jb>255 then jb:=255;

{$endif}
           gclr.r:=jr;
           gclr.g:=jg;
           gclr.b:=jb;
           end;{ With tempvtx ... }
      end; { calc light effect }
until num=0; { from top }

end;



type Xface=record ii:Array[0..3] of integer;St:Longint;Cl:Integer;end;
     Nf=array[0..1000] of xface;

procedure XCulling;
var face:^nf;
    V3d :^nX;
    i,th,NUM:Longint;
    a1,a2:record x,y,z:single end;
    xxx:single;
    rnm:integer;
begin
     rnm:=trans.flags and xlrenormal;
     Face:=TLdataF;
     v3d:=tldatav;
     for th:=0 to TLNUMV-1 DO VERTLIGHT[TH]:=0;
     for th:=0 to TLNUMF-1 DO FACESHOW[TH]:=0;
     NUM:=TLNUMF;
     repeat
        Dec(num);
        with Face^[num] do begin
             if rnm>0 then begin
                a1.x:=v3d^[ii[0]].crd.x-v3d^[ii[1]].crd.x;
                a1.y:=v3d^[ii[0]].crd.y-v3d^[ii[1]].crd.y;
                a1.z:=v3d^[ii[0]].crd.z-v3d^[ii[1]].crd.z;
                a2.x:=v3d^[ii[2]].crd.x-v3d^[ii[1]].crd.x;
                a2.y:=v3d^[ii[2]].crd.y-v3d^[ii[1]].crd.y;
                a2.z:=v3d^[ii[2]].crd.z-v3d^[ii[1]].crd.z;

                xxx:=sqrt(a1.x*a1.x+a1.y*a1.y+a1.z*a1.z);
                xxx:=xxx*sqrt(a2.x*a2.x+a2.y*a2.y+a2.z*a2.z);
                facenorm[num].nix:=(a2.z*a1.y-a1.z*a2.y)/xxx;
                facenorm[num].niy:=(a2.x*a1.z-a1.x*a2.z)/xxx;
                facenorm[num].niz:=(a2.y*a1.x-a1.y*a2.y)/xxx;
             end;

           If (tempz[ii[0]]<=0) or (tempz[ii[1]]<=0) or (tempz[ii[2]] <=0) then Continue;
           If (ii[3]>=0) and (tempz[ii[3]]<=0) then Continue;
// culling
           if (ST AND FCCULL=0) AND
              ((tempvtx[ii[2]].crd.x-tempvtx[ii[1]].crd.x)*
              (tempvtx[ii[0]].crd.y-tempvtx[ii[1]].crd.y)-
              (tempvtx[ii[0]].crd.x-tempvtx[ii[1]].crd.x)*
              (tempvtx[ii[2]].crd.y-tempvtx[ii[1]].crd.y)>0) then continue;




           VERTLIGHT[II[0]]:=1;
           VERTLIGHT[II[1]]:=1;
           VERTLIGHT[II[2]]:=1;
           IF II[3]>=0 THEN VERTLIGHT[II[3]]:=1;
           FACESHOW[NUM]:=1;
        END;
     until num=0;
end;

procedure XRASTERING;
var face:^nf;
    th,TZ,NUM,Td:Longint;
begin
     Face:=TLdataF;
     NUM:=TLNUMF;
     repeat
          dec(num);
          with Face^[num] do begin
               IF FACESHOW[NUM]=0 THEN CONTINUE;
               Dtguroud:=primpt;
               with dtguroud^.Info do begin
                        UnitType        :=St shr 0 and 7;
                        AlphaType       :=St shr 3 and 7;
                        TxNo            :=St shr 6 and 31;
                        Texcmb          :=St shr 11 and 3;
                        Alpno           :=St shr 13 and 3;
                        IF (UNITTYPE =UTFLAT) or (UNITTYPE=UTFLATTEX) THEN
                        with tempvtx[ii[0]].gclr do
                        flcol           :=((r shr 3) shl 11) or ((g shr 3) shl 6) or (g shr 3);
                        If Ii[3]<>-1 then NumVertex:=4 else NumVertex:=3;
               end; {WITH }
               Tz:=0;
               td:=0;
               For th:=0 to 3 do
               if ii[th]>-1 then begin
                   move(tempvtx[ii[th]], dtguroud^.datas[th],sizeof(x_rvertex));
                   Tz:=Tz+Tempz[ii[th]];
                   inc(td);
               end; {FOR }
               if td>0 then Query_Unit(tz div td+zadd);
          end; {WITH }
     until num=0; {REPEAT }
end;