{*********************************************************}
{*                     FUNSTR.PAS                        *}
{*          Copyright (c)  Sergey Perevoznik             *}
{* Portions Copyright (c) TurboPower Software 1987, 1992 *}
{* Portions Copyright 1991 TechnoJock Software, Inc.     *}
{*                 All rights reserved.                  *}
{*********************************************************}


unit FunStr;
  {-Basic string manipulation routines}

interface

Uses SysUtils;

  {-------- Numeric conversion -----------}

function HexB(B : Byte) : string;
  {-Return hex string for byte}

function HexW(W : Word) : string;
  {-Return hex string for word}

function HexL(L : LongInt) : string;
  {-Return hex string for longint}

function HexPtr(P : Pointer) : string;
  {-Return hex string for pointer}

function BinaryB(B : Byte) : string;
  {-Return binary string for byte}

function BinaryW(W : Word) : string;
  {-Return binary string for word}

function BinaryL(L : LongInt) : string;
  {-Return binary string for longint}

function OctalB(B : Byte) : string;
  {-Return octal string for byte}

function OctalW(W : Word) : string;
  {-Return octal string for word}

function OctalL(L : LongInt) : string;
  {-Return octal string for longint}


Function  Str2Byte(S:String)             :Byte;
  {-Return byte for string}

Function  HexStr2Byte(Str:String)        :Byte;
  {-Return byte for hex string}

Function  Str2Word(S:String)             :Word;
  {-Return word for string}

Function  HexStr2Word(Str:String)        :Word;
  {-Return word for hex string}

Function  Str2Int(Str:string)            :Integer;
  {-Return integer for string}

Function  HexStr2Int(Str:string)         :Integer;
  {-Return integer for hex string}

Function  Str2Long(Str:string)           :Longint;
  {-Return longint for string}

Function  HEXStr2Long(Str:String)        :LongInt;
  {-Return longint for hex string}

Function Str2Real(S : string)            :Real;
  {-Return real for string}

Function HexStr2Real(Str : string)       :Real;
  {-Return real for hex string}

Function  Int2Str(i:LongInt)             :String;
  {-Return string for integer}

Function  Word2Str(w:Word)               :String;
  {-Return string for word}

Function  Byte2Str(b:Byte)               :String;
  {-Return string for byte}

Function  Real2Str(r:Real;Len,Decim:Byte):String;
  {-Return string for real}

Function Long2Str(L : LongInt) : string;
  {-Convert a longint/word/integer/byte/shortint to a string}


  {-------- General purpose string manipulation --------}

function Upcase(Ch : Char) : Char;
  {-Return uppercase of char, with international character support}

function StUpcase(S : string) : string;
  {-Convert lower case letters in string to uppercase, with intl chars}

function LoCase(Ch : Char) : Char;
  {-Return lowercase of char, with international character support}

function StLocase(S : string) : string;
  {-Convert upper case letters in string to lowercase, with intl chars}

function CharStr(Ch : Char; Len : Byte) : string;
  {-Return a string of length len filled with ch}

Function  FillCh(Sym:Char;L:Byte) :String;
  {-Return a string of length len filled with ch}

Function  Space(L:Byte)           :String;
  {-Return a string of length len filled with space}

function PadCh(S : string; Ch : Char; Len : Byte) : string;
  {-Return a string right-padded to length len with ch}

function Pad(S : string; Len : Byte) : string;
  {-Return a string right-padded to length len with blanks}

function LeftPadCh(S : string; Ch : Char; Len : Byte) : string;
  {-Return a string left-padded to length len with ch}

function LeftPad(S : string; Len : Byte) : string;
  {-Return a string left-padded to length len with blanks}

function TrimLead(S : string) : string;
  {-Return a string with leading white space removed}

function TrimTrail(S : string) : string;
  {-Return a string with trailing white space removed}

function Trim(S : string) : string;
  {-Return a string with leading and trailing white space removed}

function CenterCh(S : string; Ch : Char; Width : Byte) : string;
  {-Return a string centered in a string of Ch with specified width}

function Center(S : string; Width : Byte) : string;
  {-Return a string centered in a blank string of specified width}

Function  TruncL(N:Byte;Str:String) :String;
  {-Return a string of length N }

Function  TruncR(N:Byte;Str:String):String;
  {-Return a string of length N }

  {--------------- Word manipulation -------------------------------}

function PosWord(Wordno:byte;Str:string):byte;

function WordCnt(Str:string):byte;

function ExtractWords(StartWord,NoWords:byte;Str:string):string;

FUNCTION ValidNumeric(Value : string) : boolean;

  {==========================================================================}

implementation

type
  Long =
    record
      LowWord, HighWord : Word;
    end;
const
  Digits : array[0..$F] of Char = '0123456789ABCDEF';

  function HexB(B : Byte) : string;
    {-Return hex string for byte}
  begin
    HexB[0] := #2;
    HexB[1] := Digits[B shr 4];
    HexB[2] := Digits[B and $F];
  end;

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexL(L : LongInt) : string;
    {-Return hex string for LongInt}
  begin
    with Long(L) do
      HexL := HexW(HighWord)+HexW(LowWord);
  end;

  function HexPtr(P : Pointer) : string;
    {-Return hex string for pointer}
  begin
    HexPtr := HexW(Seg(P^))+':'+HexW(Ofs(P^));
  end;

  function BinaryB(B : Byte) : string;
    {-Return binary string for byte}
  var
    I, N : Word;
  begin
    N := 1;
    BinaryB[0] := #8;
    for I := 7 downto 0 do begin
      BinaryB[N] := Digits[Ord(B and (1 shl I) <> 0)]; {0 or 1}
      Inc(N);
    end;
  end;

  function BinaryW(W : Word) : string;
    {-Return binary string for word}
  var
    I, N : Word;
  begin
    N := 1;
    BinaryW[0] := #16;
    for I := 15 downto 0 do begin
      BinaryW[N] := Digits[Ord(W and (1 shl I) <> 0)]; {0 or 1}
      Inc(N);
    end;
  end;

  function BinaryL(L : LongInt) : string;
    {-Return binary string for LongInt}
  var
    I : LongInt;
    N : Byte;
  begin
    N := 1;
    BinaryL[0] := #32;
    for I := 31 downto 0 do begin
      BinaryL[N] := Digits[Ord(L and LongInt(1 shl I) <> 0)]; {0 or 1}
      Inc(N);
    end;
  end;

  function OctalB(B : Byte) : string;
    {-Return octal string for byte}
  var
    I : Word;
  begin
    OctalB[0] := #3;
    for I := 0 to 2 do begin
      OctalB[3-I] := Digits[B and 7];
      B := B shr 3;
    end;
  end;

  function OctalW(W : Word) : string;
    {-Return octal string for word}
  var
    I : Word;
  begin
    OctalW[0] := #6;
    for I := 0 to 5 do begin
      OctalW[6-I] := Digits[W and 7];
      W := W shr 3;
    end;
  end;

  function OctalL(L : LongInt) : string;
    {-Return octal string for word}
  var
    I : Word;
  begin
    OctalL[0] := #12;
    for I := 0 to 11 do begin
      OctalL[12-I] := Digits[L and 7];
      L := L shr 3;
    end;
  end;

function Str2Int(Str:string):integer;
var temp,code : integer;
begin
   if length(Str) = 0 then
      Str2Int := 0
   else
   begin
      val(Str,temp,code);
      if code = 0 then
         Str2Int := temp
      else
       raise EConvertError.Create('  ');
   end;
end; {Str2Int}

Function  Str2Word(S:String):Word;
  var
    code : Word;
    SLen : Byte absolute S;
    I    : Word;
  begin
    while S[SLen] = ' ' do
      Dec(SLen);
    Val(S, I, code);
    IF ( code = 0  ) THEN
      Str2Word := I
       else
        raise EConvertError.Create('  ');

End;

function Str2Long(Str:string):Longint;
var
  code : integer;
  Temp : longint;
begin
   if length(Str) = 0 then
      Str2Long := 0
   else
   begin
      val(Str,temp,code);
      if code = 0 then
         Str2Long := temp
      else
        raise EConvertError.Create('  ');

   end;
end; {Str2Long}

  Function Str2Real(S : string) : Real;
  var
    Code, I : Word;
    SLen : Byte absolute S;
    R : real;
  begin
    while S[SLen] = ' ' do
      Dec(SLen);

    Val(S, R, Code);
    if Code <> 0 then
        raise EConvertError.Create('  ')
    else
      Str2Real := R;
  end;

  function Long2Str(L : LongInt) : string;
    {-Convert a long/word/integer/byte/shortint to a string}
  var
    S : string;
  begin
    Str(L, S);
    Long2Str := S;
  end;

Function Real2Str(r:Real;Len,Decim:Byte):String;
VAR
 s:String;
 L:Byte ABSOLUTE s;
 i:Byte;
Begin
 STR(r:Len:Decim,s);
 s:=Trim(s);
{ IF Decim>0 Then While (s[l]='0') AND (s[l-1]<>'.') DO DEC(l);}
 IF l>Len Then
   Begin
    STR(r:Len,s); s:=Trim(s);
    i:=POS('E',s)+2;
    IF COPY(s,i,2)='00' Then DELETE(s,i,2);
   End;
 Real2Str:=s;
End;


  function CharStr(Ch : Char; Len : Byte) : string;
    {-Return a string of length len filled with ch}
  var
    S : string;
  begin
    if Len = 0 then
      CharStr[0] := #0
    else begin
      S[0] := Chr(Len);
      FillChar(S[1], Len, Ch);
      CharStr := S;
    end;
  end;

  function PadCh(S : string; Ch : Char; Len : Byte) : string;
    {-Return a string right-padded to length len with ch}
  var
    o : string;
    SLen : Byte absolute S;
  begin
    if Length(S) >= Len then
      PadCh := S
    else begin
      o[0] := Chr(Len);
      Move(S[1], o[1], SLen);
      if SLen < 255 then
        FillChar(o[Succ(SLen)], Len-SLen, Ch);
      PadCh := o;
    end;
  end;

  function Pad(S : string; Len : Byte) : string;
    {-Return a string right-padded to length len with blanks}
  begin
    Pad := PadCh(S, ' ', Len);
  end;

  function LeftPadCh(S : string; Ch : Char; Len : Byte) : string;
    {-Return a string left-padded to length len with ch}
  var
    o : string;
    SLen : Byte absolute S;
  begin
    if Length(S) >= Len then
      LeftPadCh := S
    else if SLen < 255 then begin
      o[0] := Chr(Len);
      Move(S[1], o[Succ(Word(Len))-SLen], SLen);
      FillChar(o[1], Len-SLen, Ch);
      LeftPadCh := o;
    end;
  end;

  function LeftPad(S : string; Len : Byte) : string;
    {-Return a string left-padded to length len with blanks}
  begin
    LeftPad := LeftPadCh(S, ' ', Len);
  end;

  function TrimLead(S : string) : string;
    {-Return a string with leading white space removed}
  var
    I : Word;
  begin
    I := 1;
    while (I <= Length(S)) and (S[I] <= ' ') do
      Inc(I);
    Dec(I);
    if I > 0 then
      Delete(S, 1, I);
    TrimLead := S;
  end;

  function TrimTrail(S : string) : string;
    {-Return a string with trailing white space removed}
  var
    SLen : Byte absolute S;
  begin
    while (SLen > 0) and (S[SLen] <= ' ') do
      Dec(SLen);
    TrimTrail := S;
  end;

  function Trim(S : string) : string;
    {-Return a string with leading and trailing white space removed}
  var
    I : Word;
    SLen : Byte absolute S;
  begin
    while (SLen > 0) and (S[SLen] <= ' ') do
      Dec(SLen);

    I := 1;
    while (I <= SLen) and (S[I] <= ' ') do
      Inc(I);
    Dec(I);
    if I > 0 then
      Delete(S, 1, I);

    Trim := S;
  end;

  function CenterCh(S : string; Ch : Char; Width : Byte) : string;
    {-Return a string centered in a string of Ch with specified width}
  var
    o : string;
    SLen : Byte absolute S;
  begin
    if SLen >= Width then
      CenterCh := S
    else if SLen < 255 then begin
      o[0] := Chr(Width);
      FillChar(o[1], Width, Ch);
      Move(S[1], o[Succ((Width-SLen) shr 1)], SLen);
      CenterCh := o;
    end;
  end;

  function Center(S : string; Width : Byte) : string;
    {-Return a string centered in a blank string of specified width}
  begin
    Center := CenterCh(S, ' ', Width);
  end;

Function UpCase(Ch:Char):Char;  Assembler;
               ASM
                MOV AL,&Ch
                CMP AL,$61
                JL @@1
                CMP AL,$7A
                JG @@1
                JMP @@2
               @@1:
                CMP AL,$A0
                JL @@3
                CMP AL,$AF
                JG @@3
                JMP @@2
               @@3:
                CMP AL,$E0
                JL @@4
                CMP AL,$EF
                JG @@4
                SUB AL,$50
                JMP @@4
               @@2:
                SUB AL,$20
               @@4:
End;

Function LoCase(Ch:Char):Char;  Assembler;
               ASM
                MOV AL,&Ch
                CMP AL,$41
                JL @@1
                CMP AL,$5A
                JG @@1
                JMP @@2
               @@1:
                CMP AL,$80
                JL @@3
                CMP AL,$8F
                JG @@3
                JMP @@2
               @@3:
                CMP AL,$90
                JL @@4
                CMP AL,$9F
                JG @@4
                ADD AL,$50
                JMP @@4
               @@2:
                ADD AL,$20
               @@4:
End;

Function StUpCase(S: String): String; assembler;
asm
        PUSH DS
        CLD
        LDS  SI, S
        LES  DI, @Result
        LODSB
        STOSB
        XOR AH,AH
        XCHG AX,CX
        JCXZ @2
  @1:
        LODSB
        CMP  AL, 'a'
        JB   @3
        CMP  AL, 'z'
        JA   @3
        SUB  AL, 20h
  @3:   CMP  AL, ''
        JB   @4
        CMP  AL, ''
        JA   @4
        SUB  AL, 20h
  @4:   CMP  AL, ''
        JB   @5
        CMP  AL, ''
        JA   @5
        SUB  AL,50h
        JMP  @5
  @5:   STOSB
        LOOP @1
  @2:
        POP DS
End;


Function StLoCase(S: String): String; assembler;
asm
        PUSH DS
        CLD
        LDS  SI, S
        LES  DI, @Result
        LODSB
        STOSB
        XOR AH,AH
        XCHG AX,CX
        JCXZ @@4

   @@1:
       LODSB
       CMP AL, 'A'
       JB  @@3
       CMP AL, 'Z'
       JBE @@2
       CMP AL, ''
       JB  @@3
       CMP AL, ''
       JBE @@2
       CMP AL, ''
       JA  @@3
       ADD AL, 80
       JMP @@3
   @@2:
       ADD AL, 32
   @@3:
       STOSB
       LOOP  @@1
   @@4:
   POP DS
End;

Function  FillCh(Sym:Char;L:Byte):String;  Assembler;
ASM
 PUSH DS
 LES   DI,@Result
 XOR  CX,CX
 MOV   CL,L
 CMP   CL,0
 MOV AL,CL
 STOSB
 MOV CL,AL
 JE  @@1
 MOV   AL,SYM
 CLD
 REP   STOSB
@@1:
 POP DS
end;


Function  Str2Byte(S:String):Byte;
VAR
 VByte :Byte;
 i     :Byte;
Begin
 VByte:=0;
 For I:=1 To LENGTH(S)  DO
  VByte:=VByte OR ((Byte(S[LENGTH(S)-i+1])-48) SHL (i-1));
 Str2Byte:=VByte;
End;

function HEXStr2Byte(Str:String):Byte;
{}
begin
   if Str = '' then
      HexStr2Byte := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HexStr2Byte := Str2Byte(Str);
   end;
end; {HexStr2Byte}

function HEXStr2Word(Str:String):Word;
{}
begin
   if Str = '' then
      HexStr2Word := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HexStr2Word := Str2Word(Str);
   end;
end; {HexStr2Word}

function HEXStr2Int(Str:String):Integer;
{}
begin
   if Str = '' then
      HexStr2Int := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HexStr2Int := Str2Int(Str);
   end;
end; {HexStr2Int}


function HEXStr2Real(Str:String):Real;
{}
begin
   if Str = '' then
      HexStr2Real := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HexStr2Real := Str2Real(Str);
   end;
end; {HexStr2Real}

function HEXStr2Long(Str:String):LongInt;
{}
begin
   if Str = '' then
      HexStr2Long := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HexStr2Long := Str2Long(Str);
   end;
end; {HexStr2Long}

Function Int2Str(i:LongInt):String;
VAR
  s:String;
Begin
 STR(i,s);
 Int2Str:=s;
End;


Function Word2Str(w:Word):String;
VAR
 s:String;
Begin
 STR(w,s);
 Word2Str:=s;
End;

Function Byte2Str(B:Byte):String;
VAR
 s:String;
Begin
 STR(B,s);
 Byte2Str:=s;
End;




function TruncR(N:Byte;Str:String):String; assembler;
asm
  PUSH DS
  CLD
  LDS SI,STR
  LES DI, @RESULT
  LODSB
  XOR AH,AH
  MOV BL,AL      {࠭塞    BL}
  XCHG AX,CX
  JCXZ @3
  MOV BH,N
  CMP BL,BH
  JBE @2
  SUB BL,BH
  MOV CL,BL
  MOV AL,N
  STOSB
@1:
  LODSB
  LOOP @1
  JMP @6
@2:
  MOV AL,BL
  STOSB
  MOV CL,BL
  JMP @5
@6:
  MOV CL,N
@5:
  LODSB
  STOSB
  LOOP @5
  JMP @4
@3:
  MOV AL,0
  STOSB
@4:
  POP DS
end;  {TruncR}

function TruncL(N:Byte;Str:String):String; assembler;
asm
  PUSH DS
  CLD
  LDS SI,STR
  LES DI,@RESULT
  LODSB
  MOV BL,AL
  XOR AH,AH
  XCHG AX,CX
  JCXZ @3
  MOV BH,N
  CMP BL,BH
  JAE @2
  MOV AL,BL
  STOSB
  XOR CX,CX
  MOV CL,BL
  JMP @1
@2:
  MOV CL,N
  MOV AL,N
  STOSB
@1:
  LODSB
  STOSB
  LOOP @1
  JMP @4
@3:
  MOV AL,0
  STOSB
@4:
  POP DS
end;  {TruncL}


Function  Space(L:Byte):String;  Assembler;
ASM
 PUSH DS
 LES   DI,@Result
 XOR  CX,CX
 MOV   CL,L
 CMP   CL,0
 MOV AL,CL
 STOSB
 MOV CL,AL
 JE  @@1
 MOV   AL,32
 CLD
 REP   STOSB
@@1:
 POP DS
End;


function LocWord(StartAT,Wordno:byte;Str:string):byte;
{local proc used by PosWord and Extract word}
var
  W,L: integer;
  Spacebefore: boolean;
begin
   if (Str = '') or (wordno < 1) or (StartAT > length(Str)) then
   begin
       LocWord := 0;
       exit;
   end;
   SpaceBefore := true;
   W := 0;
   L := length(Str);
   StartAT := pred(StartAT);
   while (W < Wordno) and (StartAT <= length(Str)) do
   begin
      StartAT := succ(StartAT);
      if SpaceBefore and (Str[StartAT] <> ' ') then
      begin
         W := succ(W);
         SpaceBefore := false;
      end
      else
         if (SpaceBefore = false) and (Str[StartAT] = ' ') then
            SpaceBefore := true;
   end;
   if W = Wordno then
      LocWord := StartAT
   else
      LocWord := 0;
end;

function PosWord(Wordno:byte;Str:string):byte;
begin
   PosWord := LocWord(1,wordno,Str);
end;  {Word}

function WordCnt(Str:string):byte;
var
  W,I: integer;
  SpaceBefore: boolean;
begin
   if Str = '' then
   begin
      WordCnt := 0;
      exit;
   end;
   SpaceBefore := true;
   W := 0;
   For  I :=  1 to length(Str) do
   begin
      if SpaceBefore and (Str[I] <> ' ') then
      begin
         W := succ(W);
         SpaceBefore := false;
      end
      else
         if (SpaceBefore = false) and (Str[I] = ' ') then
            SpaceBefore := true;
   end;
   WordCnt := W;
end;

function ExtractWords(StartWord,NoWords:byte;Str:string):string;
var Start, finish : integer;
begin
   if Str = '' then
   begin
      ExtractWords := '';
      exit;
   end;
   Start := LocWord(1,StartWord,Str);
   if Start <> 0 then
      finish := LocWord(Start,succ(NoWords),Str)
   else
   begin
      ExtractWords := '';
      exit;
   end;
   if finish = 0 then
      finish := succ(length(Str));
   repeat
      finish := pred(finish);
   until Str[finish] <> ' ';
   ExtractWords := copy(Str,Start,succ(finish-Start));
end;  {ExtractWords}


{*******************************************************************************
  ValidNumeric - 24.09.97 15:31
 BY:

********************************************************************************}
FUNCTION ValidNumeric(Value : string) : boolean;
 var I : integer;
BEGIN
     ValidNumeric := true;
     for I := 1 to Length(Value) do
     begin
        if (Value[I] in ['0'..'9']) = false then  {1.00b}
          begin
           ValidNumeric := false;
           Exit;
          end;

     end;


END; {ValidNumeric}

end.
