PAGE 80,132
TITLE TP 4.0 16-bit Move procedures

; MOVES.ASM - Move16, Move16n
; Makes a copy of one array of bytes to another.  Overlapping is accounted for
; for.  Both routines are about twice as fast the original TP move, because
; 16-bit transfers are used in lieu of the 8-bit.

; Move16 is a suitable replacement for TP move and is only 11 bytes more.
; Just like TP move, it is used for INTRAsegment moves.

; Move16n is needed for special applications for Pointers such as the heap
; when you need to make absolutely sure there is no overlap.  It is used for
; either INTER- or INTRA-segment moves.  The "n" stands for normalize which
; always makes the offset less than 16.  Because it normalizes the pointers,
; it takes a little longer to get started.

;   by James H. LeMay, CIS 76011,217

CODE   SEGMENT WORD PUBLIC
       ASSUME  CS:CODE
       PUBLIC  Move16, Move16n

; procedure Move16 (VAR Source,Dest; NumOfBytes: word);
; Parameters:  Source,Dest - Double word pointers
;              NumOfBytes  - Number of bytes to move

Source      EQU   DWORD PTR [bp+0Ch]
Dest        EQU   DWORD PTR [bp+08h]
NumOfBytes  EQU   WORD  PTR [bp+06h]

Move16       PROC FAR
       push  bp                ; Save Turbo's BP
       mov   bp,sp             ; Set up stack frame
       mov   dx,ds             ; Save Turbo's DS
       lds   si,Source         ; Load pointer
       les   di,Dest           ; Load pointer
       mov   cx,NumOfBytes     ; Move count
Equal: cmp   si,di             ; Overlap?
       jb    Rev               ;   yes, reverse direction
Fwd:   cld                     ;   no, direction forward
       shr   cx,1              ; Bytes -> words
       jnc   Word2             ; Even number of bytes?
       movsb                   ;   no, move first one
       jmp   SHORT Word2       ; Now do words
Rev:   std                     ;   yes, reverse direction
       add   si,cx             ; adjust source
       dec   si                ;
       add   di,cx             ; adjust dest
       dec   di                ;
       shr   cx,1              ; Bytes -> words
       jnc   Word1             ; Even number of bytes?
       movsb                   ;   no, move first one
Word1: dec   si                ; Adjust source
       dec   di                ; Adjust dest
Word2: rep   movsw             ; Move 'em!
       mov   ds,dx             ; Restore Turbo's DS
       pop   bp                ; Restore Turbo's BP
       ret   10                ; Return to call
Move16       ENDP


; procedure Move16n (VAR Source,Dest; NumOfBytes: word);
; Parameters:  Source,Dest - Double word pointers
;              NumOfBytes  - Number of bytes to move

Mask15      EQU   00001111b

Normalize    PROC NEAR
       mov   ax,es             ; Copy seg
       mov   bx,di             ; Copy offset
       mov   cl,4              ; Set counter
       shr   bx,cl             ; Divide by 16
       add   ax,bx             ; Add to segment
       and   di,Mask15         ; Remainder in seg
       ret                     ; Return to call
Normalize    ENDP

Move16n      PROC FAR
       push  bp                ; Save Turbo's BP
       mov   bp,sp             ; Set up stack frame
       mov   dx,ds             ; Save Turbo's DS
       ; -- Load and normalize Source pointer --
       les   di,Source         ; Load pointer temporarily
       call  normalize         ; Normalize pointer
       mov   ds,ax             ; copy new Source seg
       mov   si,di             ; copy new Source ofs
       ; -- Load and normalize Dest pointer --
       les   di,Dest           ; Load pointer
       call  normalize         ; Normalize pointer
       mov   es,ax             ; copy new Dest seg
       mov   cx,NumOfBytes     ; Move count
       ; -- Now compare segments --
       mov   bx,ds             ; Copy Source seg in BX
       cmp   ax,bx             ; Overlap?
       je    Equal             ;   maybe
       ja    Fwd               ;   no, do move
       jmp   SHORT Rev         ;   yes, reverse direction
Move16n      ENDP

CODE   ENDS

       END
