{$R+,I+}
{$M 45000,0,655360}
unit NGDCTPU;

interface

Procedure Bread(var F : file; var BUF; COUNT : word; var RESULT : word);
Procedure Bskip(var F : file; N : longint);
Procedure Bseek(var F : file; P : longint);
Function  Bpos(var F : file) : longint;

implementation

{$define Buffered}

{$ifdef Buffered}

const
  MaxFbuf = 1024;

var
  BUF_FIL : array [1..MaxFbuf] of byte;
  BUF_INP : 0..MaxFbuf;
  BUF_CUR : 1..MaxFbuf + 1;

Procedure Bread(var F : file; var BUF; COUNT : word; var RESULT : word);
  type
    ByteArray = array [1..MaxInt] of byte;
  var
    DONE, N : word;
    BUF_ARR : ByteArray absolute BUF;
  begin
    RESULT := 0;
    if (COUNT > BUF_INP) or (BUF_INP = 0) then
      begin
        if (BUF_INP > 0) then Move(BUF_FIL[BUF_CUR], BUF, BUF_INP);
        DONE := BUF_INP;
        while (DONE < COUNT) do
          begin
            BlockRead(F, BUF_FIL, MaxFbuf, RESULT); BUF_INP := RESULT;
            if (BUF_INP < 1) then
              begin
{           writeln('BufIO.bread: unexpected eof.'); }
                FillChar(BUF, COUNT, 0); RESULT := 0; Exit;
              end;
            BUF_CUR := 1; N := COUNT - DONE;
            if (N > BUF_INP) then N := BUF_INP;
            Move(BUF_FIL[BUF_CUR], BUF_ARR[DONE + 1], N);
            Inc(DONE, N); Dec(BUF_INP, N); Inc(BUF_CUR, N);
          end;
      end
    else
      begin
        Move(BUF_FIL[BUF_CUR], BUF, COUNT); Dec(BUF_INP, COUNT);
        Inc(BUF_CUR);
      end;
    RESULT := COUNT;
  end;

Procedure Bseek(var F : file; P : longint);
  begin
    Seek(F, P); BUF_INP := 0; BUF_CUR := 1;       {flush buffer}
  end;

Function Bpos(var F : file) : longint;
  begin
    Bpos := FilePos(F) - BUF_INP;
  end;

Procedure Bskip(var F : file; N : longint);
  begin
    if (N < BUF_INP) then
      begin
        Dec(BUF_INP, N); Inc(BUF_CUR, N);
      end
    else begin
           Bseek(F, Bpos(F) + N);
         end;
  end;

{$else}

Procedure Bread(var F : file; var BUF; COUNT : word; var RESULT : word);
  begin
    BlockRead(F, BUF, COUNT, RESULT);
    if (RESULT < 1) then
      begin
        Writeln('NGDC: unexpected EOF.');
      end;
  end;

Procedure bseek(var F : file; P : longint);
  begin
    Seek(F, P);
  end;

Function Bpos(var F : file) : longint;
  begin
    Bpos := FilePos(F);
  end;

Procedure Bskip(var F : file; N : longint);
  begin
    Bseek(F, FilePos(F) + N);
  end;

{$endif}

(*
var SaveExitProc : Pointer;

{$F+} procedure MyExitProc; {$F-}
begin
  ExitProc := SaveExitProc;
end;
*)

begin
{$ifdef Buffered}
  BUF_INP := 0; BUF_CUR := 1;
{$endif}
end.
