{$R+,I+,V-}

Program NGDC;

uses
  Crt,
  Dos,
  Ngdctpu;

const
  MaxNameLen = 40;
  MaxLineLen = 160;

type
  BigStr = string[255];
  gentry = record                    {General entry type}
             filptr:longint;
             name:string[MaxNameLen];
           end;
  line   = string[MaxLineLen];

var
  mennu:array[0..3,0..8] of gentry;  {Buffer to hold variable part of guide menu structure}
     itemlist:array[0..3] of byte;               {Menu structure info}
     Error : array[3..6] of string[14];        {Buffer for error messages}
     F_INP : file;                                                                                    {The guide file}
     propath,homedir,streng:string;              {String variables, mostly for path and file use}
     erro,
        seealsonum,
        menuantal,
        menunr : byte;                           {Byte variables}
     entrytype : (et_misc, et_short, et_long);
     guidename : line;

const
  MaxLevel   = 10;
  OutBufSize = 4096;

type
  FileBuffer = array [1..OutBufSize] of byte;

var
  ATTR_1, ATTR_2 : byte;
  F_OUT : array [1..MaxLevel] of text;
  F_LEV : 1..MaxLevel;
     OutBuf  : array [1..MaxLevel] of ^FileBuffer;
     Nfiles  : word;
     numentries : longint;

Procedure Initialize;                     {Initialize variables}
  var
    S5 : string;
  begin
    Menunr := 0;
    Error[3] := 'File not found';
    Error[4] := 'Not an NG file';
    Error[5] := 'Unexpected EOF';
    Error[6] := 'Corrupted file';
    S5 := ''; Propath := ParamStr(0);
    while (pos('\',propath) > 0) do begin
        S5 := S5 + Copy(Propath, 1, Pos('\', Propath));
        propath := copy(propath,pos('\',propath)+1,length(propath)-(pos('\',propath)+1));
    end;
    propath := S5;
end;

Procedure WriteNgString(var FOUT : text; S : string);
  var
    I, J : byte;
    CH   : char;
  begin
    I := 1; ATTR_1 := ATTR_2;
    while (I <= Length(S)) do
      begin
        CH := S[I];
        if CH = #255 then
          begin
            {Expand spaces}
            Inc(I); CH := S[I];
            for J := 1 to Ord(CH) do
              begin
                Write(FOUT, ' ');
              end;
          end
        else
          begin
            if (CH = '!') and (I = 1) then Write(FOUT, CH);
            Write(FOUT, CH);
          end;
        Inc(I);
      end;
    Writeln(FOUT);
  end;

Procedure WriteString(S : string);
  begin
    WriteNgString(F_OUT[F_LEV], S);
  end;

{procedure ShowFile(s:string);
begin
  gotoxy(Fx, Fy); ClrEol; write(s);
end;

procedure ShowGuide(s:string);
begin
  gotoxy(Gx, Gy); ClrEol; write(s);
end;

procedure ShowCount(n:longint);
begin
write(n:7);
end;
}
Procedure Usage;
  begin
    Writeln; Writeln('Usage: ', ParamStr(0), ' filename[.ng]');
    Writeln; Halt(1);
  end;

Procedure Help;
  begin
    Writeln; TextAttr := 15; Write('---->'); TextAttr := 13;
    Writeln(' NOT for commercial use! Based in part on the public domain');
    Writeln('units by J. P. Pedersen and E. van Asperen. Many thanks to both.');
    Usage;
  end;

Procedure slutlort(B : byte);
{Exit on error and display relevant error message}
  begin
    if B > 3 then Close(F_INP);
    if B > 2 then
      begin
        Writeln('NGDC ERROR #', B, ': ' + Error[b] + ', cannot proceed...');
      end;
    if B < 3 then Usage; Halt(0);
  end;

Procedure sllut(B : byte);
{Error handler without exit, just indicating the error type}
  var
    BT : byte;
  begin
    BT := 0; if BT > 3 then Close(F_INP);
    Writeln(' ', Error[B],' - Press any key...'); erro := 1;
  end;

Function Decrypt(B : byte) : byte;
{Decrypt byte from NG format}
  begin
    Decrypt := B xor (16 + 8 + 2);
  end;

Function Read_b : byte;
{Read and decrypt byte}
  var
    B : byte;
    W : word;
  begin
    BRead(F_INP, B, 1, W); Read_b := B xor 26;
  end;

Function Read_w : word;
{Read and decrypt word}
  var
    B : byte;
  begin
    B := Read_b; Read_w := Word(B) or (Word(Read_b) shl 8);
  end;

Function Read_l : longint;
{Read and decrypt longint}
  var
    W : word;
  begin
    W := Read_w; Read_l := Longint(W) or (Longint(Read_w) shl 16);
  end;

Procedure Read_S(MaxLen : byte; var S : BigStr);
  var
    B, J : byte;
  begin
    J := 0;
    repeat
      B := Read_b; Inc(J); S[J] := Chr(B);
    until (B = 0) or (J = MaxLen);
    S[0] := Chr(J - 1);
  end;

Procedure Read_m1;
{Read a menu structure into the menu buffer}
  var
    items,i,j:word;
  begin
  mennu[menunr,0].filptr := BPos(F_INP) - 2;
  bskip(F_INP, 2);
  items := Read_w;
  itemlist[menunr] := items;
  bskip(F_INP, 20);
  for i := 1 to items-1 do begin
    mennu[menunr,i].filptr := Read_l;
  end;
  bskip(F_INP, items * 8);
  for i := 0 to items-1 do begin
     with mennu[menunr, i] do begin
        Read_s(40, name);
     end;
  end;
  bskip(F_INP, 1);
end;

procedure skip_short_long;       {Skip procedure for the initial menu bseek}
var length:word;
begin
  Length := Read_w;
  bskip(F_INP, Length + 22);
end;

procedure read_header(modf:byte); {Read NG file header and enter the guide name in the screen template}
var buf       : array[0..377] of byte;
    i,numread : word;
begin
  bread(F_INP, buf, sizeof(buf), numread);
  if ((buf[0]<>ord('N')) or (buf[1]<>ord('G'))) then begin
     {If the two first characters in the file are not 'NG', the file is no guide}
     if modf = 0
      then slutlort(4)
      else sllut(4);
  end;

  menuantal := buf[6];
  i := 0;
  repeat
    guidename[i+1] := chr(buf[i+8]);
    inc(i);
  until (buf[i+8] = 0);
  guidename[0] := chr(i);

  Writeln(guidename); BSeek(F_INP, 378);
end;

procedure read_menus(modf:boolean);  {Initial menu bseek, indexing the whole file}
var id : word;
begin
  repeat
    id := Read_w;
    if (id < 2) then begin
       skip_short_long
    end
    else if (id = 2) then begin
       Read_m1;
       inc(menunr);
    end
    else if (id <> 5) then begin
       if (filesize(F_INP) <> bpos(F_INP)) then begin
          if (not modf)
           then slutlort(5)
           else sllut(5);        {NG file error}
       end
       else id := 5;
    end;
  until (id = 5);

  if (menunr <> menuantal) then begin
     if (not modf)
      then slutlort(6)
      else sllut(6);                {Incomplete file}
  end;
end;

function MakeName:Dos.PathStr;
var fname:Dos.PathStr;
begin
  inc(Nfiles);
  str(Nfiles, fname);
  MakeName := fname;
end;

Procedure OpenOutFile(N : word; S : DOS.PathStr);
  begin
    Assign(F_OUT[N], S); Rewrite(F_OUT[N]);
    SetTextBuf(F_OUT[N], OutBuf[n]^, OutBufSize);
  end;

procedure read_entry(level:byte; fp:longint); forward;

procedure read_short_entry(level:byte);
{Read short entry from file and wring some information out of it}
var i, items: word;
    subject : line;
    entrypos, subj_pos, p0, p   : longint;
begin
  bskip(F_INP, 2);
  items := Read_w;
  bskip(F_INP, 20);
  p0 := bpos(F_INP);
  subj_pos := p0 + longint(items) * 6;
  for i := 1 to items do begin
    bskip(F_INP, 2);
    entrypos := Read_l;
    p := bpos(F_INP);
    bseek(F_INP, subj_pos);
    Read_s(MaxLineLen, subject);
    subj_pos := bpos(F_INP);
    write(F_OUT[F_LEV], '!short:'); WriteString(subject);
    read_entry(level+1, entrypos);
    bseek(F_INP, p);
  end;
end;

procedure read_long_entry;
{Read long entry information}
const MaxSeeAlso = 20;
var i, linens, dlength, seealso_num : word;
    s : line;
begin
  bskip(F_INP, 2); linens := Read_w; dlength := Read_w;
  bskip(F_INP, 18);       { 10 + links to prev/next entry (long's) }
  for i := 1 to linens do begin
    Read_s(MaxLineLen, s);
    WriteString(s);
  end;

  if dlength <> 0 then begin            {If there are seealso entries, read them}
     seealso_num := Read_w;
     { skip the offsets for the SeeAlso-items; }
     bskip(F_INP, seealso_num * 4);
     { read the items; }
     for i := 1 to seealso_num do begin
        if i <= MaxSeeAlso then begin
           Read_s(MaxLineLen, s);
           writeln(F_OUT[F_LEV], '!seealso: "', s, '"');
        end;
     end;
  end;
end;

Procedure Read_Entry(LEVEL : byte; FP : longint);
{Read some kind of file entry}
  var
    WD     : word;
    F_NAME : DOS.PathStr;
  begin
    Inc(numentries); bseek(F_INP, fp);
    WD := Read_w;
    case WD of
      0 : begin
            if (level > 0) then begin
           F_NAME := MakeName;
           writeln(F_OUT[F_LEV], '!file: ', F_NAME + '.NGO');
           Inc(F_LEV);
           OpenOutFile(F_LEV, F_NAME + '.NGS');
           read_short_entry(level); Close(F_OUT[F_LEV]);
           Dec(F_LEV);
        end
        else begin
           read_short_entry(level);
        end;
      end;
   1: begin
        read_long_entry;
      end;
  end;
end;


Procedure Main;
  label
    NEXT;
  var
    i,j,k:word;
    linkf : text;
    fname : Dos.PathStr;
  begin
    numentries := 0;

  { create Menu Link Control File; }
    Assign(linkf, 'GUIDE.LCF'); rewrite(linkf);
  writeln(linkf, '!name:'^i, guidename);
  writeln(linkf);

  for i := 0 to menuantal-1 do begin
     writeln(linkf, '!menu:'^i, mennu[i,0].name);
     for j := 1 to itemlist[i]-1 do begin
        close(F_OUT[F_LEV]);
        fname := MakeName;
        OpenOutFile(F_LEV, fname + '.NGS');
        writeln(linkf, ^i, mennu[i,j].name, ^i, fname+'.ngo');
        read_entry( 0, mennu[i,j].filptr );
Next:
     end;
  end;

  close(linkf);

  { write a makefile; }
  assign(linkf, 'MAKEGUID'); rewrite(linkf);
  writeln(linkf, '.dat.ngo:');
  writeln(linkf, ^i'ngc $<');
  writeln(linkf);
  write(linkf, 'OBJECTS=');
  j := 0;
  for i := 1 to Nfiles do begin
     str(i, fname);
     fname := fname + '.ngo ';
     write(linkf, fname);
     inc(j, length(fname));
     if (j > 65) then begin
        write(linkf, '\'^m^j^i);
        j := 0;
     end;
  end;
  writeln(linkf);
  writeln(linkf);
  writeln(linkf, 'guide.ng:	$(OBJECTS)');
  writeln(linkf, ^i'ngml guide.lcf');
  close(linkf);
end;

var i:byte;
begin                        {Main loop and command-line parser}
  Writeln(' The Norton Guide Decompiler. V.1/00. (C)opyright 1992 Single M.');
  Writeln('Free for non-commercial personal use. Type NGDC -? for more help.');
  F_LEV := 1; Nfiles := 0;
  for i := 1 to MaxLevel do begin
    new(OutBuf[i]);
  end;

  Assign(F_OUT[F_LEV], 'GUIDE.DAT'); Rewrite(F_OUT[F_LEV]);
  SetTextBuf(F_OUT[F_LEV], OutBuf[F_LEV]^, OutBufSize);


  Initialize;

  if ((ParamStr(1) = '/?') or (ParamStr(1) = '-?')) then
    begin
      Help;
    end;

  if (ParamCount <> 1) then
    begin
      Usage;
    end;

  streng := paramstr(1);

  if pos('.',streng)=0
   then streng := streng+'.NG';        {Expand file name}

  assign(F_INP, streng);
{$I-}
  reset(F_INP, 1);
  if ioresult<>0 then slutlort(3);   {If file does not exist, terminate and write cause of death}
{$I+}

{  ScreenInit;
  ShowFile(streng);
  ShowMenu('reading menu-info...');}
  read_header(0);
  read_menus(False);
  Main;

  Close(F_INP); Close(F_OUT[F_LEV]);
  { ScreenExit;}
end.
