Unit vUtil;
{ ⥪ 楤  㭪権  REZIP }

{$S-}
interface

uses Dos;
TYPE DriveType = String[2];

{**************************************}
{-------- Disk/File Operations -------------}
Procedure SetCurDrive (Drive:DriveType);
Function  ChangeDir(path:string):boolean;
Function  MakeDIR(path:string):boolean;
Function  DirExists(Strn:String):Boolean;
Function  GetStartDir:String;
Function  GetCurDir:String;
Function  GetCurDrive:DriveType;

{--- Convert Case ---}
Function  UpCase(Ch:Char):Char;
Function  LoCase(Ch:Char):Char;
Function  StUpCase(S:String):String;
{--- Manipulate String ---}
Function  StrTran(S:String;Chf,Chr:Char):String;
Function  Left(S:String;n:byte):String;
Function  BackPos(Ch:Char;Line:string):Byte;
{ ---------------------------------------------------------- }
implementation
{--------------------------------------------------------------------}
Function GetCurDrive:DriveType;
{   get current drive }
VAR n:byte;
begin
   Asm
   mov   ah,19h
   int   21h
   mov   [n],al
   end;
   GetCurDrive:=Chr(n+65)+':';

end;

{--------------------------------------------------------------------}
Procedure SetCurDrive (Drive:DriveType);
{   set current drive }
VAR
   n:byte;
begin
   n:=ORD(Drive[1])-65;
Asm

   mov   ah,0Eh
   mov   dl,[n]
   int   21h

end;
end;

{ ---------------------------------------------------------- }
Function  GetStartDir:String;
Var
   S:string;
   p:byte;
begin
   S:=ParamStr(0);
   p:=BackPos('\',S);
   S[0]:=Chr(p);
   GetStartDir:=S;
end;

{ ---------------------------------------------------------- }
Function  GetCurDir:String;
Var S:String;
begin
   GetDir(0,S);
   GetCurDir:=S;
end;

{-----------------------------------------------------------}
Function DirExists(Strn:String):Boolean;
var
    DirInfo: SearchRec;
begin
         FindFirst(Strn, Directory, DirInfo);
         DirExists:=(DosError = 0);
end;

(*--------------------------------------------------------------------*)
(*    M A K E D I R                                                   *)
(*                                                                    *)
(*    Like mkdir() but create intermediate directories as well        *)
(*--------------------------------------------------------------------*)

Function MakeDIR(path:string):boolean;
Var

   p:byte;
   subpath:string;
   l:byte absolute subpath;
   Res:boolean;
begin

   if (path = '') then res:=False
{   else if DirExists(path) then res:=True}
   else begin

        path:=StrTran(path,'/','\');
   subpath:='';

   { see if we need to make any intermediate directories }
   while (path<>'') do begin
      p := Pos('\',path) ;
      If p > 0 then begin
         If SubPath='' then SubPath:=Left(Path,p-1)
                       else SubPath:=SubPath+'\'+Left(Path,p-1);
         If not (Copy(Path,2,2) = '\') then begin
            if not DirExists(SubPath) then begin
               {$i-}
               MkDir(Left(SubPath,l-1));
               {$i-}
               If IoResult<>0 then begin
                  res:=False;
                  break;
               end;
               {   Quit(1,'MakeDir: Can''t create ',SubPath);}
            end;
         end;
         Delete(Path,1,p);
      end;
   end;
   end;
   MAKEDIR:=Res;

end;

(*--------------------------------------------------------------------*)
(*    C H A I N G E D I R                                             *)
(*                                                                    *)
(*    Like chdir() but create the directory if necessary              *)
(*--------------------------------------------------------------------*)

Function CHANGEDIR(path:string):boolean;
Var
   res:boolean;
   l:byte absolute path;
begin
   res:=False;

   if path = '' then res:=True
   else begin
      If Path[l]='\' then Dec(l);
      {$i-}
      ChDir(path);
      {$i+}
      If IOResult=0 then res:=True
      else begin
         if MakeDIR(path) then begin
            { change to last directory }
            chdir(path);
            res:=True;
         end;
      end;
   end;

   ChangeDir:=res;

end;

{-----------------------------------------------------------}
Function BackPos(Ch:Char;Line:string):Byte;
var
         Point:Byte;
         i:byte;
         l:byte absolute Line;

begin
        Point:=0;
        For i:=l downto 1 do begin
                If Line[i]=Ch then begin
                        Point:=i;
                        i:=1;
                end;
        end;
        BackPos:=Point;
end;

{--------------  ---------------------------}
Function  StrTran(S:String;Chf,Chr:Char):String;
var
  i : Integer;
begin
  for i := 1 to Length(s) do
    If s[i] = Chf then s[i]:=Chr;
  StrTran:=S;
end;

{------------------------------------------------------}
Function UpCase(Ch : Char) : Char; Assembler;
{Return uppercased char, with Russian character support}

Asm
        mov     al,ss:[bp+6]
       { -----------  Convert English Characters }
        CMP     AL,'a'
        JB      @1               { if AL < 'a'          }
        CMP     AL,'z'
        JA      @2               { if AL > 'z'          }
        SUB     AL,20H           { Convert to uppercase }
        JMP     @1
        { -----------  Convert Russian Characters}
@2:
       CMP AL,''
       JB  @1

       CMP AL,''
       JA  @3
       AND AL,0DFH      { Convert chars "..." }
        JMP     @1
@3:
       CMP AL,''
       JB  @1

       CMP AL,''
       JA  @4
       SUB AL,050H      { Convert chars "..." }
        JMP     @1
@4:
       CMP AL,''
       JNE @1
       DEC AL           { Convert e: -> E:        }
@1:
END;

{-------------------------------------------------------}
Function Locase(Ch : Char) : Char; Assembler;
{Return lowercased char, with Danish character support  }
Asm
        mov     al,ss:[bp+6]
        { -----------  Convert English Characters  }
        CMP     AL,'A'
        JB      @1                { if AL < 'A'    }
        CMP     AL,'Z'
        JA      @2                { if AL > 'Z'    }
        ADD     AL,20H            { Convert to lowercase }
        JMP     @1
        { -----------  Convert Russian Characters }
@2:
       CMP AL,''
       JB  @1

       CMP AL,''
       JA  @3
       ADD AL,20H      { Convert chars "..." }
        JMP     @1
@3:
       CMP AL,''
       JB  @1

       CMP AL,''
       JA  @4
       ADD AL,050H      { Convert chars "..." }
        JMP     @1
@4:
       CMP AL,''
       JNE @1
       INC AL           { Convert E: -> e:  }
@1:
END;

{--------------  ---------------------------}
Function StUpCase(S:String):String;
var
  i : Integer;
begin
  for i := 1 to Length(s) do
    s[i] := Upcase(s[i]);
  StUpCase:=S;
end;

{**}
Function Left(S:String;n:byte):String;
Var Stmp:string;
begin
   Stmp:=Copy(S,1,n);
   Left:=Stmp;
end;

end.


