{ ARCHIVE REPACKER v.1.2  For DOS              }
{ (c) 1994 by Valery Votintsev, Info-Link, ltd.}

{**}
PROGRAM REZIP;
{$M 16384, 0, 0}
USES Dos,vUtil,Execute;
{$S-}
CONST
   Title = 'ARCHIVE REPACKER (c) 1994 by Valery Votintsev';
   { UnPackers }
   ARJ  = 'c:\archive\arj.exe';     { ARJ Unpacker         }
   UNZIP= 'c:\archive\pkunzip.exe'; { ZIP Unpacker         }
   ZIP  = 'c:\archive\pkzip.exe';   { ZIP Packer           }
   RAR  = 'c:\archive\rar.exe';     { RAR Unpacker         }
   LHA  = 'c:\archive\lha.exe';     { LHA/LZH/ICE Unpacker }
   UNARC= 'c:\archive\pkxarc.com';  { ARC Unpacker         }
   ARC  = 'c:\archive\pkarc.com';   { ARC Packer         }

Var
{-----------------------------------------------------------------}

   DirInfo: SearchRec;
   InMask,
   StartDir,
   OldDir,
   TempDir:String;
   OldDrive,
   NewDrive:DriveType;
   FileCounter:Integer;
   Post_File,Conf_File:string;
   SingleFile:Boolean;
   Debug:Boolean;
   i:integer;
   FileName: PathStr;  { Path to file to get }
   S:String;

    {----------------------------------------------}
    Function ReadArchiveHeader(FName:String):String;
    Var
      F:File;
      Buf:String;
      i,n:word;
    begin
      ReadArchiveHeader:=UNZIP;
      For n:=1 to 255 do Buf[n]:=#0;
      Buf[0]:=#255;

      Assign(F,FName);
      {$i-}
      Reset(F,1);
      BlockRead(F,Buf[1],255,n);
      If      Pos('RSFX',Buf)>0 then ReadArchiveHeader:=RAR
      else If Pos('RJSX',Buf)>0 then ReadArchiveHeader:=ARJ
      else If Pos('PKLITE',Buf)>0 then ReadArchiveHeader:=UNZIP
      else If Pos('LH''s SFX',Buf)>0 then ReadArchiveHeader:=LHA
      else If Pos('LHice''s SFX',Buf)>0 then ReadArchiveHeader:=LHA
      else                                   ReadArchiveHeader:='';
      Close(F);
      {$i+}
    end;


    {----------------------------------------------}
    Function CheckArchiveType(FName:String):String;
    Var
      n:byte;
      F:File;
      Ext,Ext2:string;
    begin
      Ext:='   ';
      n:=Pos('.',FName);
      If n > 0 then Ext:=Copy(FName,n+1,3);
      Ext2:=Copy(Ext,2,2);

      CheckArchiveType:='';

      If        Ext='ARJ' then CheckArchiveType:=ARJ
{      else   If (Ext[1]='A') and (IsNumeric(Ext2)) then CheckArchiveType:=ARJ}
      else   If Ext='RAR' then CheckArchiveType:=RAR
{      else   If (Ext[1]='R') and (IsNumeric(Ext2)) then CheckArchiveType:=RAR}
      else   If Ext='ZIP' then CheckArchiveType:=UNZIP
      else   If Ext='LHA' then CheckArchiveType:=LHA
      else   If Ext='LZH' then CheckArchiveType:=LHA
      else   If Ext='ICE' then CheckArchiveType:=LHA
      else   If Ext='ARC' then CheckArchiveType:=UNARC
      else   If Ext='EXE' then CheckArchiveType:=ReadArchiveHeader(FName)
      else   If Ext='COM' then CheckArchiveType:=ReadArchiveHeader(FName)
      else                     CheckArchiveType:='';
    end;



{**}
Function Archiver(fullname:string;commandnum:integer):Boolean;
{Send Archive Contents List }
Var
    nPos:byte;
    Body:String;
    ListName,Origin,ReplyStr:String;
    UnPacker,Param:string;
    command,
    ListCommand,
    CheckCommand,
    PackCommand,
    UnpackCommand:string;
    TmpFile:Text;

Begin

        UnPacker:=CheckArchiveType(FullName);

        If      (Unpacker=UNZIP) then ListCommand:='-VB '
        else If (UnPacker=UNARC) then ListCommand:='-V '
        else If (UnPacker=ARJ)   then ListCommand:='L '
        else If (UnPacker=RAR)   then ListCommand:='L '
        else If (UnPacker=LHA)   then ListCommand:='L '
        else                          ListCommand:='V ';

        If      (Unpacker=UNZIP) then CheckCommand:='-T '
        else If (UnPacker=UNARC) then CheckCommand:='-T '
        else If (UnPacker=ARJ)   then CheckCommand:='T '
        else If (UnPacker=RAR)   then CheckCommand:='T '
        else If (UnPacker=LHA)   then CheckCommand:='T '
        else                          CheckCommand:='T ';

        If      (Unpacker=UNZIP) then UnPackCommand:='-X '
        else If (UnPacker=UNARC) then UnPackCommand:='-X '
        else If (UnPacker=ARJ)   then UnPackCommand:='X -Y -V '
        else If (UnPacker=RAR)   then UnPackCommand:='X '
        else If (UnPacker=LHA)   then UnPackCommand:='X '
        else                          UnPackCommand:='X ';

        If      (Unpacker=UNZIP) then PackCommand:='-M -PR '
        else If (UnPacker=UNARC) then PackCommand:='-M '
        else If (UnPacker=ARJ)   then PackCommand:='M '
        else If (UnPacker=RAR)   then PackCommand:='M '
        else If (UnPacker=LHA)   then PackCommand:='M '
        else                          PackCommand:='M ';

        If commandnum = 0 then
           command:=CheckCommand
        else If commandnum = 1 then
           command:=ListCommand
        else If commandnum = 2 then
           command:=UnPackCommand
        else If commandnum = 3 then begin
           command:=PackCommand;
           If      (Unpacker=UNZIP) then Unpacker:=ZIP
           else If (UnPacker=UNARC) then Unpacker:=ARC;
        end;

        Param:= Command + FullName;

        If not Debug then Param:=Param+' > nul';

        SwapVectors;

        Exec(UnPacker,Param);

        ExitCode := DOSExitCode; { Return the exit code for error trapping }

        SwapVectors;

        Archiver:=(ExitCode = 0);

end;

Procedure WriteOk(Ok:Boolean);
begin
   If Ok then Writeln(' - Ok')
         else Writeln(' - Error!');
end;

Function CheckArchive(fname:string):Boolean;
Var Ok:boolean;
begin
   Write('Checking   '+fname);
   Ok:=Archiver(fname,0);
   CheckArchive:=Ok;
   WriteOk(Ok);
end;

Function ListArchive(fname:string):Boolean;
Var Ok:boolean;
begin
   Write('Listing    '+fname);
   Ok:=Archiver(fname,1);
   ListArchive:=Ok;
   WriteOk(Ok);
end;

Function UnPackArchive(fname:string):Boolean;
Var Ok:boolean;
begin
   Write('Unpacking  '+fname);
   Ok:=Archiver(fname+' '+TempDir+'\',2);
   UnPackArchive:=Ok;
   WriteOk(Ok);
end;

Function PackArchive(fname:string):Boolean;
Var Ok:boolean;
begin
   Write('Packing    '+fname);
   Ok:=Archiver(OldDir+'\'+fname,3);
   PackArchive:=Ok;
   WriteOk(Ok);
end;

{**}
Function CopyFile(fname1,fname2:string):Boolean;
Begin
   Write('Copy/B     '+fname1+' '+fname2);
   SwapVectors;
   Exec('C:\COMMAND.COM','/C COPY/B '+fname1+' '+fname2 + ' > nul');
   ExitCode := DOSExitCode; { Return the exit code for error trapping }
   SwapVectors;
   WriteOk(ExitCode=0);
   CopyFile:=(ExitCode=0);
end;


{**}
Function DelFiles(fname:string):Boolean;
Begin
   Write('Deleting   '+fname);
   SwapVectors;
   Exec('C:\COMMAND.COM','/C DEL '+fname);
   ExitCode := DOSExitCode; { Return the exit code for error trapping }
   SwapVectors;
   WriteOk(ExitCode=0);
   DelFiles:=(ExitCode=0);
end;


{**}
Procedure ProcessNextFile(fname:string);
Var
   i:integer;
   path,
   name,
   ext,
   zipFile:string;
   Ok:boolean;
   Info:SearchRec;
Begin
   Ok:=TRUE;

   FSplit(fname,path,name,ext);
   ext:=StUpcase(ext);

   If (ext = '') or (ext='.ZIP') or
      (ext='.EXE') or  (ext='.COM') then begin end
   else begin

      path:=CheckArchiveType(fname);

      If path = '' then begin end
      else begin

         Writeln('');
         Writeln ('Processing ',fName);

         Ok := CheckArchive(fname);

         If Ok then begin
            If Ok then Ok:= UnpackArchive(fname);

            If Ok then begin
               NewDrive:=LEFT(TempDir,2);
               SetCurDrive(NewDrive);
               ChangeDir(TempDir);

               zipfile:=name+'.ZIP';

               Ok := PackArchive(zipfile);

               FindFirst('*.*', Archive, Info );
                  { Search something after DEL *.*}
               If DosError = 0 then begin
                  Ok:=FALSE;
                  WRiteln('*** Can''t erase '+TempDir+'\*.*  for '+fname);
               end;

               SetCurDrive(OldDrive);  {Let's return to old drive & path}
               ChangeDir(OldDir);

               If Ok then begin
                  If ext = '.ARJ' then
                     Ok:= DelFiles(name+'.A??')
                  else If ext = '.RAR' then
                     Ok:= DelFiles(name+'.R??')
                  else Ok:=DelFiles(fname);
               end;

               If Ok then Inc(FileCounter)
                     else Halt(1);
{               SetCurDrive(OldDrive);}
               If SingleFile then Halt;
            end;
         end;
      end;
   end;
end;


{**}
Begin

   StartDir:=GetStartDir;
   OldDir:=GetCurDir;
   OldDrive:=GetCurDrive;
   TempDir :='C:\TEMP';
   InMask :='*.*';
   FileCounter:=0;
   SingleFile:=FALSE;
   Debug:=FALSE;

   Writeln('');
   Writeln(Title);   { Draw Title}

   For i:=1 to ParamCount do begin
      S:=StUpCase(ParamStr(i));
      If S = '/S' then SingleFile:=TRUE
      else If S='/X' then Debug:=TRUE
      else If Pos('\',S) > 0 then TempDir:=ParamStr(i);
   end;

   IF not DirExists(TempDir) then begin
      MakeDir(TempDir);
   end;

   FindFirst(InMask, Archive, DirInfo); { Same as DIR *.ARJ }

   While DosError = 0 do begin
      ProcessNextFile(DirInfo.name);
      FindNext(DirInfo);
   end;

   Writeln('------------------------------------');
   Writeln('Total Files Handled: ',FileCounter);

end.


