/*
 * miniGL_main.h
 *
 * miniGL for the Palm Computing platform
 * Michael Sherman <msherman@dsbox.com>
 * (c) 2000 Digital Sandbox, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MINIGL_MAIN_H__
#define __MINIGL_MAIN_H__

void minigllib_glmultmatrixf(const GLfloat *input);
void minigllib_glloadmatrixf(const GLfloat *m);
void minigllib_glloadidentity();
void minigllib_glclearcolor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void minigllib_glclear(GLbitfield mask);
void minigllib_glcolor3f(GLfloat r, GLfloat g, GLfloat b);
void minigllib_glcolor4f(GLfloat r, GLfloat g, GLfloat b, GLfloat a);
void minigllib_glortho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
		GLdouble near, GLdouble distant);
void minigllib_gluortho2d(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top);
void minigllib_glviewport(GLint x, GLint y, GLsizei width, GLsizei height);
void minigllib_gluperspective(GLdouble fovy, GLdouble aspect, GLdouble near, 
			GLdouble distant);
void minigllib_glbegin(GLenum mode);
void minigllib_glend(void);
void minigllib_glutswapbuffers();
void minigllib_glflush(void);
void minigllib_glvertex3f(GLfloat x, GLfloat y, GLfloat z);
void minigllib_glvertex2f(GLfloat x, GLfloat y);
void minigllib_glshademodel(GLenum mode);
void minigllib_glrotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void minigllib_glscalef(GLfloat x, GLfloat y, GLfloat z);
void minigllib_gltranslatef(GLfloat x, GLfloat y, GLfloat z);
void minigllib_glpopmatrix();
void minigllib_glpushmatrix();
void minigllib_glmatrixmode(GLenum mode);
void minigllib_glnormal3f(GLfloat nx, GLfloat ny, GLfloat nz);
void minigllib_glenable(GLenum cap);
void minigllib_gldisable(GLenum cap);
void minigllib_gllightfv(GLenum light, GLenum pname, const GLfloat *params);
void minigllib_glgetlightfv(GLenum light, GLenum pname, GLfloat *params);
void minigllib_glpolygonmode(GLenum face, GLenum mode);
void minigllib_winsetglArea(int x1, int y1, int x2, int y2);
void minigllib_glmap2f(GLenum target,
                        GLfloat u1, GLfloat u2, GLint ustride, GLint uorder,
                        GLfloat v1, GLfloat v2, GLint vstride, GLint vorder,
                        const GLfloat *points);
void minigllib_glmapgrid2f(GLint un, GLfloat u1, GLfloat u2,
                        GLint vn, GLfloat v1, GLfloat v2);
void minigllib_glevalmesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void minigllib_glpushattrib(GLbitfield mask);
void minigllib_glpopattrib();
void minigllib_gldrawpixels(GLsizei width, GLsizei height, GLenum format,
                        GLenum type, const GLvoid *pixels);
void minigllib_glbitmap(GLsizei width, GLsizei height, GLfloat xbo,
                        GLfloat ybo, GLfloat xbi, GLfloat ybi,
                        const GLubyte *bitmap);
void minigllib_winremoveglarea();

#endif

/*
 * End of miniGL_main.h
 */
