unit MainFormUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Local, global,
  StdCtrls;

type
  TMainForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.Button1Click(Sender: TObject);
begin
    if GHookInstalled=true then exit; //if a global hook is installed, exit routine
     //if a local hook not installed, then attempt to install one, else attempt to remove one
     if HookInstalled=false then HookInstalled:=SetupLocalHook else HookInstalled:=not(RemoveLocalHook);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
     HookInstalled:=false;
     GHookInstalled:=false;
     LibLoaded:=false;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
     if HookInstalled=true then RemoveLocalHook;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
     if HookInstalled=true then exit; //if a local hook is installed, exit routine
     //if a local hook not installed, then attempt to install one, else attempt to remove one
     //note that removelocalhook can still be used no matter whether the hook is global or local
     if GHookInstalled=false then GHookInstalled:=SetupGlobalHook else GHookInstalled:=not(RemoveLocalHook);
end;

end.
