//********************************************
// Texture.h
//********************************************
// class CTexture
//********************************************
// This object stores a bitmap image used as
// an OpenGL texture.
// Files are stored as 24 bits .bmp format
//********************************************
// pierre.alliez@cnet.francetelecom.fr
// Created : 17/12/97
// Modified : 09/10/00
//********************************************

#ifndef _TEXTURE_
#define _TEXTURE_

class CDC;

class CTexture
{

// Members datas
private :

	unsigned char *m_pData;    // datas
	unsigned int   m_Width;    // width (pixels)
	unsigned int   m_Height;   // height (pixels)
	unsigned int   m_Depth;    // bits per pixel 

	BITMAPINFOHEADER m_Header;      // image header (display on device context)
	unsigned int     m_WidthByte32; // width (in bytes, and 32 bits aligned)

public :

	// Life cycle
	CTexture();
	~CTexture();

	// I/O
	int ReadFileBMP24(char *filename);
	int SaveFileBMP24(char *filename);
	int ReadFromResource(const WORD ResourceId);
	
	// Display
	int Draw(CDC *pDC,int xOffset=0,int yOffset=0, int width=-1, int height=-1);

	// Memory
	int Alloc(unsigned int width,unsigned int height,unsigned int depth);
	void Free(void);

	// Clipboard
	HANDLE ExportHandle();
	int ImportHandle(HANDLE handle);

	// Datas
	unsigned int GetWidth(void)  { return m_Width; }
	unsigned int GetHeight(void) { return m_Height;}
	unsigned int GetDepth(void)  { return m_Depth; }
	unsigned char *GetData(void) { return m_pData; }
	unsigned int GetWidthByte32(void)  { return m_WidthByte32; }

	// Misc
	int BGRtoRGB(void);

	// Image combination
	int Insert(CTexture *pImage,unsigned int xOffset,unsigned int yOffset);
	int AdaptiveInsert(CTexture *pImage,unsigned int xOffset,unsigned int yOffset,
					 unsigned char r,unsigned char g,unsigned char b);
	void Fill(unsigned char red,unsigned char green,unsigned char blue);

private :

	// Updating
	void UpdateWidthByte32();
	void UpdateHeader();
	unsigned int WidthByte32(unsigned int width,unsigned int depth);
};

#endif // _TEXTURE_
