// GlColorDlg.h : header file
//

#if !defined(AFX_GLCOLORDLG_H__0896DB86_A381_11D4_9DF3_CF769DBD135C__INCLUDED_)
#define AFX_GLCOLORDLG_H__0896DB86_A381_11D4_9DF3_CF769DBD135C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CColorDlg dialog

#include "gl/gl.h"
#include "gl/glu.h"
#include "Texture.h"

class CColorDlg : public CDialog
{
// Construction
public:
	CColorDlg(CWnd* pParent = NULL);	// standard constructor

	// Texture
	CTexture m_Image;

	// OpenGL
	HGLRC m_hGLContext;
	int m_GLPixelIndex;
	BOOL SetWindowPixelFormat(HDC hDC);
	BOOL CreateViewGLContext(HDC hDC);
	COLORREF m_BackColor;
	void RenderScene();
	void BuildListCube(BOOL list = TRUE);
	void BuildListCloud();
	void Init();

	// Mouse
	CPoint m_RightDownPos;
	CPoint m_LeftDownPos;
	BOOL m_RightButtonDown;
	BOOL m_LeftButtonDown;

	// Interaction
	double m_xRotate;
	double m_yRotate;
	float m_Size;

// Dialog Data
	//{{AFX_DATA(CColorDlg)
	enum { IDD = IDD_GLCOLOR_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColorDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CColorDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnEditBackcolor();
	afx_msg void OnEditLoadimage();
	afx_msg void OnPopupViewimage();
	afx_msg void OnUpdatePopupViewimage(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GLCOLORDLG_H__0896DB86_A381_11D4_9DF3_CF769DBD135C__INCLUDED_)
