// GlColorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GlColor.h"
#include "GlColorDlg.h"
#include "resource.h"
#include "DialogImage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorDlg dialog

CColorDlg::CColorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CColorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CColorDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// Initialization
	Init();
}

void CColorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CColorDlg, CDialog)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CColorDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_EDIT_BACKCOLOR, OnEditBackcolor)
	ON_COMMAND(ID_EDIT_LOADIMAGE, OnEditLoadimage)
	ON_COMMAND(ID_POPUP_VIEWIMAGE, OnPopupViewimage)
	ON_UPDATE_COMMAND_UI(ID_POPUP_VIEWIMAGE, OnUpdatePopupViewimage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorDlg message handlers

//*********************************
// OnInitDialog 
//*********************************
BOOL CColorDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);
	return TRUE;
}

//*********************************
// OnSysCommand 
//*********************************
void CColorDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
		CDialog::OnSysCommand(nID, lParam);
}


//*********************************
// OnPaint 
//*********************************
void CColorDlg::OnPaint() 
{
	// ** Draw scene **
	CPaintDC dc(this);
	RenderScene();
	SwapBuffers(dc.m_ps.hdc);
}

//*********************************
// OnQueryDragIcon 
//*********************************
HCURSOR CColorDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//*********************************
// Init 
//*********************************
void CColorDlg::Init()
{
	m_hGLContext = NULL;
	m_GLPixelIndex = 0;

	m_xRotate = 1.5;
	m_yRotate = 0;
	m_Size = 1.5f;

	m_RightButtonDown = FALSE;
	m_LeftButtonDown = FALSE;

	// Clear color
	m_BackColor = ::GetSysColor(COLOR_3DFACE);

	// Read default image from resource
	m_Image.ReadFromResource(IDR_BABOON);
}

//**********************************************
// OpenGL
//**********************************************
BOOL CColorDlg::SetWindowPixelFormat(HDC hDC)
{
	PIXELFORMATDESCRIPTOR pixelDesc;

	pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion = 1;

	pixelDesc.dwFlags = PFD_DRAW_TO_WINDOW | 
						PFD_SUPPORT_OPENGL |
						PFD_DOUBLEBUFFER |
						PFD_STEREO_DONTCARE;

	pixelDesc.iPixelType = PFD_TYPE_RGBA;
	pixelDesc.cColorBits = 32;
	pixelDesc.cRedBits = 8;
	pixelDesc.cRedShift = 16;
	pixelDesc.cGreenBits = 8;
	pixelDesc.cGreenShift = 8;
	pixelDesc.cBlueBits = 8;
	pixelDesc.cBlueShift = 0;
	pixelDesc.cAlphaBits = 0;
	pixelDesc.cAlphaShift = 0;
	pixelDesc.cAccumBits = 64;
	pixelDesc.cAccumRedBits = 16;
	pixelDesc.cAccumGreenBits = 16;
	pixelDesc.cAccumBlueBits = 16;
	pixelDesc.cAccumAlphaBits = 0;
	pixelDesc.cDepthBits = 32;
	pixelDesc.cStencilBits = 8;
	pixelDesc.cAuxBuffers = 0;
	pixelDesc.iLayerType = PFD_MAIN_PLANE;
	pixelDesc.bReserved = 0;
	pixelDesc.dwLayerMask = 0;
	pixelDesc.dwVisibleMask = 0;
	pixelDesc.dwDamageMask = 0;

	m_GLPixelIndex = ChoosePixelFormat(hDC,&pixelDesc);
	if(m_GLPixelIndex==0) // Choose default
	{
		m_GLPixelIndex = 1;
		if(!DescribePixelFormat(hDC,m_GLPixelIndex,
			sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc))
			return FALSE;
	}

	if(!SetPixelFormat(hDC,m_GLPixelIndex,&pixelDesc))
		return FALSE;

	return TRUE;
}


//*********************************
// CreateViewGLContext 
//*********************************
BOOL CColorDlg::CreateViewGLContext(HDC hDC)
{
	m_hGLContext = wglCreateContext(hDC);

	if(m_hGLContext==NULL)
		return FALSE;

	if(wglMakeCurrent(hDC,m_hGLContext)==FALSE)
		return FALSE;
	return TRUE;
}

//*********************************
// OnCreate 
//*********************************
int CColorDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	// Init OpenGL engine
	HWND hWnd = GetSafeHwnd();
	HDC hDC = ::GetDC(hWnd);

	if(SetWindowPixelFormat(hDC)==FALSE)
		return 0;
	
	if(CreateViewGLContext(hDC)==FALSE)
		return 0;

	// Antialiasing
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
	glLineWidth(1.5); // required
	glPointSize(1.0);
	glPolygonMode(GL_FRONT,GL_LINE);
	glPolygonMode(GL_BACK,GL_LINE);
  glShadeModel(GL_SMOOTH);

	// Precalculate lists
	BuildListCube();
	BuildListCloud();

	return 0;
}

//*********************************
// OnDestroy 
//*********************************
void CColorDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	if(wglGetCurrentContext() != NULL)
		 wglMakeCurrent(NULL,NULL);

	if(m_hGLContext != NULL)
	{
		wglDeleteContext(m_hGLContext);
		m_hGLContext = NULL;
	}

	glDeleteLists(1,2);
}

//*********************************
// OnSize 
//*********************************
void CColorDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	GLsizei width = cx;
	GLsizei height = cy;
	GLdouble aspect;

	if(cy==0)
		aspect = (GLdouble)width;
	else
		aspect = (GLdouble)width/(GLdouble)height;

	glViewport(0,0,width,height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45,aspect,1,100.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glDrawBuffer(GL_BACK);
	glEnable(GL_DEPTH_TEST);
}



//*********************************
// RenderScene 
//*********************************
void CColorDlg::RenderScene()
{
	::glClearColor((float)GetRValue(m_BackColor)/255.0f,
		             (float)GetGValue(m_BackColor)/255.0f,
		             (float)GetBValue(m_BackColor)/255.0f,1.0f);
	::glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	::glPushMatrix();
		::glTranslated(0.0,0.0,-8.0);
		::glRotated(m_xRotate, 1.0, 0.0, 0.0);
		::glRotated(m_yRotate, 0.0, 1.0, 0.0);
		::glCallList(1); // cube
		::glCallList(2); // clouds
 	::glPopMatrix();
}


//***********************************************
// BuildList
//***********************************************
void CColorDlg::BuildListCube(BOOL list)
{
	GLUquadricObj* pQuadric = gluNewQuadric();

	if(list)
		::glNewList(1,GL_COMPILE_AND_EXECUTE);

	float x = m_Size;

	// RGB cube
	glBegin(GL_LINE_LOOP);
	  glColor3ub(0,0,0);
		glVertex3d(-x,-x,-x);
	  glColor3ub(255,0,0);
		glVertex3d(x,-x,-x);
	  glColor3ub(255,255,0);
		glVertex3d(x,x,-x);
	  glColor3ub(0,255,0);
		glVertex3d(-x,x,-x);
	glEnd();

	glBegin(GL_LINE_LOOP);
	  glColor3ub(0,0,255);
		glVertex3d(-x,-x,x);
	  glColor3ub(255,0,255);
		glVertex3d(x,-x,x);
	  glColor3ub(255,255,255);
		glVertex3d(x,x,x);
	  glColor3ub(0,255,255);
		glVertex3d(-x,x,x);
	glEnd();

	glBegin(GL_LINES);

	  glColor3ub(0,0,0);
		glVertex3d(-x,-x,-x);
	  glColor3ub(0,0,255);
		glVertex3d(-x,-x,x);

	  glColor3ub(255,0,0);
		glVertex3d(x,-x,-x);
	  glColor3ub(255,0,255);
		glVertex3d(x,-x,x);

	  glColor3ub(255,255,0);
		glVertex3d(x,x,-x);
	  glColor3ub(255,255,255);
		glVertex3d(x,x,x);

	  glColor3ub(0,255,0);
		glVertex3d(-x,x,-x);
	  glColor3ub(0,255,255);
		glVertex3d(-x,x,x);

	glEnd();

	// Spheres
	glPolygonMode(GL_FRONT,GL_FILL);
	glPolygonMode(GL_BACK,GL_FILL);
	float radius = 0.1f;

	glPushMatrix();
	glTranslated(-m_Size,-m_Size,-m_Size);
	glColor3ub(0,0,0);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(m_Size,-m_Size,-m_Size);
	glColor3ub(255,0,0);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(-m_Size,m_Size,-m_Size);
	glColor3ub(0,255,0);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(-m_Size,-m_Size,m_Size);
	glColor3ub(0,0,255);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(m_Size,m_Size,-m_Size);
	glColor3ub(255,255,0);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(-m_Size,m_Size,m_Size);
	glColor3ub(0,255,255);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(m_Size,-m_Size,m_Size);
	glColor3ub(255,0,255);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	glPushMatrix();
	glTranslated(m_Size,m_Size,m_Size);
	glColor3ub(255,255,255);
	gluSphere(pQuadric,radius,12,12); 
	glPopMatrix();

	if(list)
		::glEndList();

	gluDeleteQuadric(pQuadric);
}

//***********************************************
// BuildListCloud
//***********************************************
void CColorDlg::BuildListCloud()
{
	TRACE("Build list cloud...");

	// Image area
	unsigned int area = m_Image.GetWidth()*m_Image.GetHeight();
	TRACE("area : %d...",area);

	// Need valid image (24 bits)
	if(area == 0 ||
		 m_Image.GetDepth() != 24)
		return;

	// Maximum -> area distinct colors / 2^24
	// This table is memory expansive, but short lived
	TRACE("alloc...");
	unsigned char *pTable = new unsigned char[16777216];
	memset(pTable,0,16777216); // init 0

	// Image data
	unsigned int wb32 = m_Image.GetWidthByte32();
	unsigned char *pData = m_Image.GetData();

	// Build a new list
	TRACE("build list...");
	int nb = 0;
	::glNewList(2,GL_COMPILE_AND_EXECUTE);
		glBegin(GL_POINTS);
		float tmp = 2.0f/255.0f*m_Size;
		for(unsigned int j=0;j<m_Image.GetHeight();j++)
			for(unsigned int i=0;i<m_Image.GetWidth();i++)
			{
				unsigned char b = pData[wb32*j+3*i];
				unsigned char g = pData[wb32*j+3*i+1];
				unsigned char r = pData[wb32*j+3*i+2];
				if(!pTable[b*65536+g*256+r])
				{
					glColor3ub(r,g,b);
					float x = -m_Size+(float)r*tmp;
					float y = -m_Size+(float)g*tmp;
					float z = -m_Size+(float)b*tmp;
					glVertex3d(x,y,z);
					pTable[b*65536+g*256+r] = 1;
					nb++;
				}
			}
		glEnd();
	::glEndList();
	TRACE("%d points...",nb);

	TRACE("cleanup...");
	delete [] pTable;
	TRACE("ok\n");
}


////////////////////////////////////////////////////////
// MOUSE INTERACTION
////////////////////////////////////////////////////////

//*********************************
// Left button 
//*********************************
void CColorDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	m_LeftButtonDown = TRUE;
	m_LeftDownPos = point;
	SetCapture();
	CDialog::OnLButtonDown(nFlags, point);
}
void CColorDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_LeftButtonDown = FALSE;
	ReleaseCapture();
	CDialog::OnLButtonUp(nFlags, point);
}

//*********************************
// Right button 
//*********************************
void CColorDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	m_RightButtonDown = TRUE;
	m_RightDownPos = point;
	SetCapture();
	CDialog::OnRButtonDown(nFlags, point);
}

void CColorDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	m_RightButtonDown = FALSE;
	ReleaseCapture();
	CDialog::OnRButtonUp(nFlags, point);
}

//*********************************
// Mouse move
//*********************************
void CColorDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(m_LeftButtonDown)
	{
		CSize rotate = m_LeftDownPos - point;
		m_LeftDownPos = point;
		m_yRotate -= rotate.cx;
		m_xRotate -= rotate.cy;
		InvalidateRect(NULL,FALSE);
	}
	CDialog::OnMouseMove(nFlags, point);
}


//*********************************
// OnContextMenu 
//*********************************
void CColorDlg::OnContextMenu(CWnd*, CPoint point)
{
	if (point.x == -1 && point.y == -1)
	{
		//keystroke invocation
		CRect rect;
		GetClientRect(rect);
		ClientToScreen(rect);
		
		point = rect.TopLeft();
		point.Offset(5, 5);
	}
		
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_COLOR_DLG));
		
	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);
	CWnd* pWndPopupOwner = this;
		
	while (pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();
	
	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
		                     point.x, point.y,pWndPopupOwner);
}

//*********************************
// OnEditBackcolor 
//*********************************
void CColorDlg::OnEditBackcolor() 
{
	CColorDialog dlg(m_BackColor);
	if(dlg.DoModal() == IDOK)
	{
		m_BackColor = dlg.GetColor();
  	glClearColor((float)GetRValue(m_BackColor)/255.0f,
		           (float)GetGValue(m_BackColor)/255.0f,
		           (float)GetBValue(m_BackColor)/255.0f,1.0f);
		InvalidateRect(NULL,FALSE);
	}
}

//*********************************
// OnEditLoadimage 
//*********************************
void CColorDlg::OnEditLoadimage() 
{
	CFileDialog dlg(TRUE,"*.bmp","*.bmp");
	if(dlg.DoModal() == IDOK)
	{
		CString name = dlg.GetPathName();
		if(m_Image.ReadFileBMP24(name.GetBuffer(MAX_PATH)))
		{
			// All right, go on
			::glDeleteLists(2,1);
			this->BuildListCloud();
			InvalidateRect(NULL,FALSE);
		}
		name.ReleaseBuffer();
	}
}

//*********************************
// OnPopupViewimage 
//*********************************
void CColorDlg::OnPopupViewimage() 
{
	CDialogImage dlg(this,&m_Image);
	dlg.DoModal();
}
void CColorDlg::OnUpdatePopupViewimage(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_Image.GetWidth() > 0 &&
		             m_Image.GetHeight() > 0);
}
